/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.markers;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.validation.problems.EProblem;
import org.eclipse.papyrus.cdo.validation.problems.ESeverity;
import org.eclipse.papyrus.cdo.validation.problems.edit.ProblemEditUtil;
import org.eclipse.papyrus.cdo.validation.problems.util.ProblemsManager;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

public class CDOPapyrusMarker
implements IPapyrusMarker {
    private final ProblemEditUtil util;
    private final Resource resource;
    private final EProblem problem;

    CDOPapyrusMarker(EProblem problem, ProblemEditUtil util) {
        this.util = util;
        this.resource = problem.getElement().eResource();
        this.problem = problem;
    }

    public static Function<EProblem, CDOPapyrusMarker> wrap(final ProblemEditUtil util) {
        return new Function<EProblem, CDOPapyrusMarker>(){

            public CDOPapyrusMarker apply(EProblem input) {
                return new CDOPapyrusMarker(input, util);
            }
        };
    }

    public Resource getResource() {
        return this.resource;
    }

    public EObject getEObject() {
        return this.problem.getElement();
    }

    public boolean exists() {
        EObject element = this.getEObject();
        return element != null && element.eResource() != null;
    }

    public String getType() {
        String result = this.problem.getType();
        return result != null ? result : "org.eclipse.emf.ecore.diagnostic";
    }

    public String getTypeLabel() throws CoreException {
        String result = MarkerListenerUtils.getMarkerTypeLabel((String)this.getType());
        return result != null && result.length() > 0 ? result : this.util.getProblemType(this.problem);
    }

    public void delete() {
        ProblemsManager.delete((EProblem)this.problem);
    }

    public Object getAttribute(String name) throws CoreException {
        Object result = null;
        if (name.equals("uri")) {
            result = EcoreUtil.getURI((EObject)this.getEObject()).toString();
        } else if (name.equals("severity")) {
            result = this.getMarkerSeverity();
        } else if (name.equals("message")) {
            result = this.problem.getMessage();
        } else if (this.problem.getAttributes().containsKey((Object)name)) {
            result = this.coerce((String)this.problem.getAttributes().get((Object)name));
        } else {
            throw new CoreException(this.error("No such marker attribute: " + name));
        }
        return result;
    }

    protected Object coerce(String value) {
        Object result = value == null ? value : (CDOPapyrusMarker.isBoolean(value) ? Boolean.valueOf(Boolean.parseBoolean(value)) : (CDOPapyrusMarker.isInteger(value) ? Integer.valueOf(Integer.parseInt(value)) : value));
        return result;
    }

    static boolean isBoolean(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false"));
    }

    static boolean isInteger(String s) {
        boolean result = s != null && s.length() > 0;
        int i = 0;
        while (result && i < s.length()) {
            result = Character.isDigit(s.charAt(i));
            ++i;
        }
        return result;
    }

    protected final IStatus error(String message) {
        return new Status(4, "org.eclipse.papyrus.cdo.ui", message);
    }

    protected int getMarkerSeverity() {
        int result;
        switch (this.problem.getSeverity()) {
            case OK: 
            case INFO: {
                result = 0;
                break;
            }
            case WARNING: {
                result = 1;
                break;
            }
            default: {
                result = 2;
            }
        }
        return result;
    }

    public String getAttribute(String name, String defaultValue) {
        String result = null;
        result = name.equals("uri") ? EcoreUtil.getURI((EObject)this.getEObject()).toString() : (name.equals("message") ? this.problem.getMessage() : (this.problem.getAttributes().containsKey((Object)name) ? this.coerce((String)this.problem.getAttributes().get((Object)name), defaultValue) : defaultValue));
        return result != null ? result : defaultValue;
    }

    protected String coerce(String value, String defaultValue) {
        String result;
        if (value == null) {
            result = defaultValue;
        } else {
            if (CDOPapyrusMarker.isBoolean(value) || CDOPapyrusMarker.isInteger(value)) {
                throw new IllegalArgumentException("Not a string value: " + value);
            }
            result = value;
        }
        return result;
    }

    public boolean getAttribute(String name, boolean defaultValue) {
        boolean result = this.problem.getAttributes().containsKey((Object)name) ? this.coerce((String)this.problem.getAttributes().get((Object)name), defaultValue) : defaultValue;
        return result;
    }

    protected boolean coerce(String value, boolean defaultValue) {
        boolean result;
        if (value == null) {
            result = defaultValue;
        } else {
            if (!CDOPapyrusMarker.isBoolean(value)) {
                throw new IllegalArgumentException("Not a boolean value: " + value);
            }
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    public int getAttribute(String name, int defaultValue) {
        int result = name.equals("severity") ? this.getMarkerSeverity() : (this.problem.getAttributes().containsKey((Object)name) ? this.coerce((String)this.problem.getAttributes().get((Object)name), defaultValue) : defaultValue);
        return result;
    }

    protected int coerce(String value, int defaultValue) {
        int result;
        if (value == null) {
            result = defaultValue;
        } else {
            if (!CDOPapyrusMarker.isInteger(value)) {
                throw new IllegalArgumentException("Not an integer value: " + value);
            }
            result = Integer.parseInt(value);
        }
        return result;
    }

    public Map<String, ?> getAttributes() throws CoreException {
        Map<String, Object> result = this.coerce((EMap<String, String>)this.problem.getAttributes());
        result.put("uri", EcoreUtil.getURI((EObject)this.getEObject()).toString());
        result.put("severity", this.getMarkerSeverity());
        result.put("message", this.problem.getMessage());
        return result;
    }

    protected Map<String, Object> coerce(EMap<String, String> attributes) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry next : attributes) {
            result.put((String)next.getKey(), this.coerce((String)next.getValue()));
        }
        return result;
    }

    public void setAttribute(String name, Object value) throws CoreException {
        if (name.equals("uri")) {
            throw new CoreException(this.error("Cannot set URI of a CDOPapyrusMarker."));
        }
        if (name.equals("severity")) {
            this.setMarkerSeverity(((Number)value).intValue());
        } else if (name.equals("message")) {
            this.problem.setMessage((String)value);
        } else if (value == null) {
            this.problem.getAttributes().removeKey((Object)name);
        } else {
            this.problem.getAttributes().put((Object)name, (Object)value.toString());
        }
    }

    protected void setMarkerSeverity(int severity) throws CoreException {
        switch (severity) {
            case 0: {
                this.problem.setSeverity(ESeverity.INFO);
                break;
            }
            case 1: {
                this.problem.setSeverity(ESeverity.WARNING);
                break;
            }
            case 2: {
                this.problem.setSeverity(ESeverity.ERROR);
                break;
            }
            default: {
                throw new CoreException(this.error("Invalid marker severity: " + severity));
            }
        }
    }

    public void setAttribute(String name, String value) throws CoreException {
        if (name.equals("uri")) {
            throw new CoreException(this.error("Cannot set URI of a CDOPapyrusMarker."));
        }
        if (name.equals("message")) {
            this.problem.setMessage(value);
        } else {
            if (name.equals("severity")) {
                throw new CoreException(this.error("Severity of a CDOPapyrusMarker is not a string."));
            }
            if (value == null) {
                this.problem.getAttributes().removeKey((Object)name);
            } else {
                this.problem.getAttributes().put((Object)name, (Object)value);
            }
        }
    }

    public void setAttribute(String name, boolean value) throws CoreException {
        if (name.equals("uri")) {
            throw new CoreException(this.error("URI of a CDOPapyrusMarker is not a boolean."));
        }
        if (name.equals("severity")) {
            throw new CoreException(this.error("Severity of a CDOPapyrusMarker is not a boolean."));
        }
        if (name.equals("message")) {
            throw new CoreException(this.error("Message of a CDOPapyrusMarker is not a boolean."));
        }
        this.problem.getAttributes().put((Object)name, (Object)Boolean.toString(value));
    }

    public void setAttribute(String name, int value) throws CoreException {
        if (name.equals("severity")) {
            this.setMarkerSeverity(value);
        } else {
            if (name.equals("uri")) {
                throw new CoreException(this.error("URI of a CDOPapyrusMarker is not an integer."));
            }
            if (name.equals("message")) {
                throw new CoreException(this.error("Message of a CDOPapyrusMarker is not an integer."));
            }
            this.problem.getAttributes().put((Object)name, (Object)Integer.toString(value));
        }
    }

    public void setAttributes(Map<String, ?> attributes) throws CoreException {
        for (Map.Entry<String, ?> next : attributes.entrySet()) {
            String name = next.getKey();
            Object value = next.getValue();
            if (name.equals("uri")) {
                throw new CoreException(this.error("Cannot set URI of a CDOPapyrusMarker."));
            }
            if (name.equals("severity")) {
                this.setMarkerSeverity(((Number)value).intValue());
                continue;
            }
            if (name.equals("message")) {
                this.problem.setMessage((String)value);
                continue;
            }
            if (value == null) continue;
            this.problem.getAttributes().put((Object)name, (Object)value.toString());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof CDOPapyrusMarker && Objects.equal((Object)((CDOPapyrusMarker)obj).problem, (Object)this.problem);
    }

    public int hashCode() {
        return this.problem == null ? 0 : this.problem.hashCode();
    }

    public String toString() {
        return String.format("CDOPapyrusMarker:%s:%s", this.getResource(), this.hashCode());
    }

    public boolean isSubtypeOf(String type) throws CoreException {
        return type == null || MarkerListenerUtils.isMarkerTypeSubtypeOf((String)this.getType(), (String)type);
    }
}

