/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.providers;

import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.eresource.util.EresourceSwitch;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CDOResourceLabelProvider
extends LabelProvider
implements IFilteredLabelProvider {
    private final ResourceManager images = new LocalResourceManager(JFaceResources.getResources((Display)Display.getDefault()));
    private final EresourceSwitch<String> nodeTypeSwitch = this.createNodeTypeSwitch();

    public boolean accept(Object element) {
        return element instanceof CDOResourceNode || element instanceof URI && CDOUtils.isCDOURI((URI)((URI)element));
    }

    public void dispose() {
        this.images.dispose();
        super.dispose();
    }

    public Image getImage(Object element) {
        return this.images.createImage(Activator.getIcon("open_repository"));
    }

    public String getText(Object element) {
        URI uri;
        String result = null;
        URI uRI = uri = element instanceof URI ? (URI)element : ((CDOResourceNode)element).getURI();
        if (uri != null) {
            String nodeType = element instanceof CDOResourceNode ? (String)this.nodeTypeSwitch.doSwitch((EObject)((CDOResource)element)) : Messages.CDOResLabels_node;
            String path = CDOURIUtil.extractResourcePath((URI)uri);
            CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)uri);
            String checkoutName = checkout == null ? Messages.CDOResLabels_unknown : checkout.getLabel();
            result = NLS.bind((String)Messages.CDOResLabels_pattern, (Object[])new Object[]{nodeType, path, checkoutName});
        }
        return result;
    }

    private EresourceSwitch<String> createNodeTypeSwitch() {
        return new EresourceSwitch<String>(){

            public String defaultCase(EObject object) {
                return Messages.CDOResLabels_nodeKind;
            }

            public String caseCDOResource(CDOResource object) {
                return Messages.CDOResLabels_modelKind;
            }

            public String caseCDOResourceFolder(CDOResourceFolder object) {
                return Messages.CDOResLabels_folderKind;
            }

            public String caseCDOBinaryResource(CDOBinaryResource object) {
                return Messages.CDOResLabels_binKind;
            }

            public String caseCDOTextResource(CDOTextResource object) {
                return Messages.CDOResLabels_txtKind;
            }

            public <IO> String caseCDOFileResource(CDOFileResource<IO> object) {
                return Messages.CDOResLabels_fileKind;
            }

            public String caseCDOResourceLeaf(CDOResourceLeaf object) {
                return Messages.CDOResLabels_leafKind;
            }
        };
    }
}

