/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.ui.SharedImages;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.statushandlers.StatusManager;

public class CheckoutSelectionBlock {
    private final EventBus bus;
    private final Supplier<? extends IRunnableContext> runnableContext;
    private TableViewer repoList;
    private CDOCheckout selectedCheckout;

    public CheckoutSelectionBlock(EventBus bus, Supplier<? extends IRunnableContext> runnableContext) {
        this.bus = bus;
        this.runnableContext = runnableContext;
    }

    public Control createControl(Composite parent) {
        CDOCheckoutManager mgr = CDOExplorerUtil.getCheckoutManager();
        this.repoList = new TableViewer(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.repoList.getControl());
        this.repoList.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.repoList.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.repoList.setInput((Object)mgr);
        if (this.selectedCheckout != null) {
            this.repoList.setSelection((ISelection)new StructuredSelection((Object)this.selectedCheckout));
            this.selected(this.selectedCheckout);
        }
        this.repoList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    if (CheckoutSelectionBlock.this.selectedCheckout != null) {
                        CheckoutSelectionBlock.this.repoList.setSelection((ISelection)new StructuredSelection((Object)CheckoutSelectionBlock.this.selectedCheckout));
                    }
                } else {
                    CheckoutSelectionBlock.this.selected((CDOCheckout)sel.getFirstElement());
                }
            }
        });
        CDOCheckout[] cDOCheckoutArray = mgr.getCheckouts();
        int n = cDOCheckoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckout next = cDOCheckoutArray[n2];
            if (next.isOpen()) {
                this.selected(next);
                this.repoList.setSelection((ISelection)new StructuredSelection((Object)next));
                break;
            }
            ++n2;
        }
        return this.repoList.getControl();
    }

    public void dispose() {
    }

    public void setEnabled(boolean enabled) {
        if (this.repoList != null) {
            this.repoList.getControl().setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.repoList != null && this.repoList.getControl().isEnabled();
    }

    void selected(final CDOCheckout checkout) {
        this.selectedCheckout = checkout;
        if (!checkout.isOpen()) {
            try {
                ((IRunnableContext)this.runnableContext.get()).run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CheckoutSelectionBlock_0, (Object)checkout.getLabel()), (int)-1);
                        try {
                            checkout.open();
                            long deadline = System.currentTimeMillis() + 5000L;
                            while (!checkout.isOpen()) {
                                Thread.sleep(250L);
                                if (System.currentTimeMillis() >= deadline) break;
                            }
                            CheckoutSelectionBlock.this.repoList.getControl().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CheckoutSelectionBlock.this.repoList.getControl().isDisposed()) {
                                        CheckoutSelectionBlock.this.repoList.update((Object)checkout, null);
                                        CheckoutSelectionBlock.this.bus.post((Object)checkout);
                                    }
                                }
                            });
                        }
                        finally {
                            sub.done();
                        }
                    }
                });
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.cdo.ui", Messages.CheckoutSelectionBlock_1, (Throwable)e), 2);
            }
        }
        this.bus.post((Object)checkout);
    }

    public void setSelectedCheckout(CDOCheckout checkout) {
        this.selectedCheckout = checkout;
        if (this.repoList != null) {
            this.repoList.setSelection((ISelection)new StructuredSelection((Object)this.selectedCheckout));
            this.selected(this.selectedCheckout);
        }
    }

    public CDOCheckout getSelectedCheckout() {
        return this.selectedCheckout;
    }

    private static class RepositoryContentProvider
    implements IStructuredContentProvider {
        private RepositoryContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            return CDOExplorerUtil.getCheckoutManager().getCheckouts();
        }

        public void dispose() {
        }
    }

    private static class RepositoryLabelProvider
    extends LabelProvider {
        private RepositoryLabelProvider() {
        }

        public Image getImage(Object element) {
            boolean open = ((CDOCheckout)element).isOpen();
            return SharedImages.getImage(open ? "open_repository" : "closed_repository");
        }

        public String getText(Object element) {
            return ((CDOCheckout)element).getLabel();
        }
    }
}

