/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.codegen.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

public class JavaIoFileSystemAccess
implements IPFileSystemAccess {
    File baseFolder;
    String subFolderName;
    boolean force = true;

    @Override
    public void generateFile(String fileName, String content) {
        File file = this.getFile(fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter writer = Files.newBufferedWriter(file.toPath(), Charset.defaultCharset(), new OpenOption[0]);
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Code generation: " + e.getMessage());
        }
    }

    @Override
    public void deleteFile(String fileName) {
        File file = this.getFile(fileName);
        file.delete();
    }

    public void setOutputPath(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void setOutputPath(File baseFolder, String folderName) {
        this.baseFolder = baseFolder;
        this.subFolderName = folderName;
    }

    public File getContainer(NamedElement element) {
        try {
            File folder = this.getFile(this.baseFolder, this.subFolderName);
            EList namespaces = element.allNamespaces();
            int i = namespaces.size() - 1;
            while (i >= 0) {
                Namespace ns = (Namespace)namespaces.get(i);
                if (!(folder = this.getFile(folder, ns.getName())).exists()) {
                    folder.createNewFile();
                }
                --i;
            }
            return folder;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getFile(String filename) {
        String[] paths = filename.split("/");
        File folder = this.getFile(this.baseFolder, this.subFolderName);
        try {
            int i = 0;
            while (i < paths.length - 1) {
                String path = paths[i];
                if (!(folder = this.getFile(folder, path)).exists()) {
                    folder.createNewFile();
                }
                ++i;
            }
            String last = paths[paths.length - 1];
            return this.getFile(folder, last);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getFile(File folder, String fileName) {
        return new File(folder, fileName);
    }
}

