/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.codegen.extensionpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class MethodInfo {
    protected String name;
    protected List<String> parameterTypes;

    public MethodInfo(String name) {
        this.name = name;
        this.parameterTypes = new ArrayList<String>();
    }

    public MethodInfo(String name, List<String> parameterTypes) {
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public static MethodInfo fromBehavior(Behavior behavior) {
        MethodInfo mi = new MethodInfo(behavior.getName());
        for (Parameter parameter : behavior.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) {
                if (parameter.getType() == null) continue;
                mi.addParameterType(parameter.getType().getQualifiedName());
                continue;
            }
            mi.addParameterType("undefined");
        }
        return mi;
    }

    public static MethodInfo fromOperation(Operation operation) {
        MethodInfo mi = new MethodInfo(operation.getName());
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) {
                if (parameter.getType() == null) continue;
                mi.addParameterType(parameter.getType().getQualifiedName());
                continue;
            }
            mi.addParameterType("undefined");
        }
        return mi;
    }

    public void addParameterType(String parameterType) {
        this.parameterTypes.add(parameterType);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }
}

