/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cpp.cdtproject;

import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.codegen.extensionpoints.AbstractSettings;
import org.eclipse.papyrus.codegen.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.cpp.cdtproject.CCNamedProjectWizard;
import org.eclipse.papyrus.cpp.cdtproject.CDTSettings;
import org.eclipse.papyrus.cpp.cdtproject.CNamedProjectWizard;
import org.eclipse.papyrus.cpp.cdtproject.CppProjectSupport;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class C_CppProjectSupport
implements ILangProjectSupport {
    private static final String ROOT = "root";
    private static final String C = "c";
    private static final String CPP = "cpp";
    private int dialogStatus;

    public IProject createProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        this.dialogStatus = 0;
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            Object wiz = this instanceof CppProjectSupport ? new CCNamedProjectWizard(projectName) : new CNamedProjectWizard(projectName);
            wiz.setWindowTitle("create project " + projectName);
            wiz.init(wb, null);
            Display.getDefault().syncExec(new Runnable((CDTCommonProjectWizard)wiz){
                private final /* synthetic */ CDTCommonProjectWizard val$wiz;
                {
                    this.val$wiz = cDTCommonProjectWizard;
                }

                @Override
                public void run() {
                    WizardDialog wizDiag = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)this.val$wiz);
                    wizDiag.create();
                    C_CppProjectSupport.this.dialogStatus = wizDiag.open();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            project = null;
        }
        if (this.dialogStatus == 1) {
            return null;
        }
        if (project == null || !project.exists()) {
            throw new RuntimeException("Could not create CDT project. This might indicate that there is a problem with your CDT installation.");
        }
        return project;
    }

    public void setSettings(IProject project, AbstractSettings abstractSettings) {
        CDTSettings settings = (CDTSettings)abstractSettings;
        try {
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription cdesc = mngr.getProjectDescription(project, true);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cdesc.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription configDescr = iCConfigurationDescriptionArray[n2];
                ICFolderDescription folderDescription = configDescr.getRootFolderDescription();
                ICLanguageSetting[] languageSettings = folderDescription.getLanguageSettings();
                ICLanguageSettingEntry[] icIncludePaths = new ICLanguageSettingEntry[settings.includePaths.size()];
                int i = 0;
                while (i < settings.includePaths.size()) {
                    icIncludePaths[i] = new CIncludePathEntry(settings.includePaths.get(i), 8);
                    ++i;
                }
                if (settings.targetOS != null) {
                    settings.macros.add("OS_" + settings.targetOS);
                }
                BasicEList icMacros = new BasicEList();
                int i2 = 0;
                while (i2 < settings.macros.size()) {
                    icMacros.add((Object)new CMacroEntry(settings.macros.get(i2), "", 0));
                    ++i2;
                }
                ICLanguageSetting[] iCLanguageSettingArray = languageSettings;
                int n3 = languageSettings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSetting lang = iCLanguageSettingArray[n4];
                    String[] stringArray = lang.getSourceExtensions();
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String ext = stringArray[n6];
                        if (ext.equals(CPP) || ext.equals(C)) {
                            ICLanguageSettingEntry[] icOldMacros;
                            lang.setSettingEntries(1, icIncludePaths);
                            ICLanguageSettingEntry[] iCLanguageSettingEntryArray = icOldMacros = lang.getSettingEntries(4);
                            int n7 = icOldMacros.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n8];
                                icMacros.add((Object)entry);
                                ++n8;
                            }
                            lang.setSettingEntries(4, (List)icMacros);
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                IConfiguration main = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescr);
                ITool cfTool = main.calculateTargetTool();
                IOption[] iOptionArray = cfTool.getOptions();
                int n9 = iOptionArray.length;
                int n10 = 0;
                while (n10 < n9) {
                    IOption opt = iOptionArray[n10];
                    if (opt.getValueType() == 6) {
                        main.setOption((IHoldsOptions)cfTool, opt, settings.libs.toArray(new String[0]));
                    } else if (opt.getValueType() == 9) {
                        main.setOption((IHoldsOptions)cfTool, opt, settings.libPaths.toArray(new String[0]));
                    }
                    ++n10;
                }
                mngr.setProjectDescription(project, cdesc, true, null);
                ++n2;
            }
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
        catch (BuildException be) {
            throw new RuntimeException(be.getMessage());
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce.getMessage());
        }
    }

    public AbstractSettings initialConfigurationData() {
        CDTSettings settings = new CDTSettings();
        settings.includePaths = new UniqueEList();
        settings.includePaths.add(".");
        settings.includePaths.add(ROOT);
        settings.libs = new UniqueEList();
        settings.libPaths = new UniqueEList();
        settings.macros = new UniqueEList();
        return settings;
    }

    public void gatherConfigData(Class implementation, AbstractSettings abstractSettings) {
        CDTSettings settings = (CDTSettings)abstractSettings;
        Element owner = implementation.getOwner();
        while (owner instanceof Package) {
            ExternLibrary cppLibrary = (ExternLibrary)UMLUtil.getStereotypeApplication((Element)owner, ExternLibrary.class);
            if (cppLibrary != null && settings != null) {
                settings.includePaths.addAll((Collection<String>)cppLibrary.getIncludes());
                for (String libPath : cppLibrary.getLibPaths()) {
                    if (libPath.startsWith("/")) {
                        settings.libPaths.add("${workspace_loc:" + libPath + "}");
                        continue;
                    }
                    settings.libPaths.add(libPath);
                }
                settings.libs.addAll((Collection<String>)cppLibrary.getLibs());
                settings.macros.addAll((Collection<String>)cppLibrary.getMacros());
            }
            owner = owner.getOwner();
        }
    }
}

