/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cpp.codegen.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.cpp.codegen.transformation.CppModelElementsCreator;
import org.eclipse.papyrus.cpp.codegen.utils.ClassUtils;
import org.eclipse.papyrus.cpp.codegen.utils.LocateCppProject;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class GenerateCodeHandler
extends CmdHandler {
    private static final boolean Headless = Boolean.getBoolean("papyrus.run-headless");

    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Package || this.selectedEObject instanceof Classifier) {
            URI uri = this.selectedEObject.eResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (uri.segmentCount() < 2) {
                return false;
            }
            IProject modelProject = root.getProject(uri.segment(1));
            return modelProject.exists();
        }
        return false;
    }

    public void generate(CppModelElementsCreator mec, PackageableElement pe, EList<PackageableElement> alreadyHandled, boolean recurse) {
        Package owningPackage;
        alreadyHandled.add((Object)pe);
        mec.createPackageableElement(pe, null, false);
        if (pe instanceof Package && recurse) {
            for (PackageableElement subPe : ((Package)pe).getPackagedElements()) {
                if (alreadyHandled.contains((Object)subPe)) continue;
                this.generate(mec, subPe, alreadyHandled, recurse);
            }
        }
        if (pe instanceof Classifier) {
            EList requiredClassifiers = ClassUtils.includedClassifiers((Classifier)((Classifier)pe));
            for (Classifier requiredClassifier : requiredClassifiers) {
                if (alreadyHandled.contains((Object)requiredClassifier)) continue;
                this.generate(mec, (PackageableElement)requiredClassifier, alreadyHandled, false);
            }
        }
        if ((owningPackage = pe.getNearestPackage()) != null && owningPackage != pe && !alreadyHandled.contains((Object)owningPackage)) {
            this.generate(mec, (PackageableElement)owningPackage, alreadyHandled, false);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof PackageableElement) {
            PackageableElement pe = (PackageableElement)this.selectedEObject;
            IProject modelProject = LocateCppProject.getTargetProject((PackageableElement)pe, (boolean)true);
            if (modelProject == null) {
                return null;
            }
            CppModelElementsCreator mec = new CppModelElementsCreator(modelProject);
            this.generate(mec, pe, (EList<PackageableElement>)new BasicEList(), true);
        }
        return null;
    }
}

