/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cpp.codegen.transformation;

import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.papyrus.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.C_Cpp.External;
import org.eclipse.papyrus.C_Cpp.Include;
import org.eclipse.papyrus.C_Cpp.ManualGeneration;
import org.eclipse.papyrus.C_Cpp.NoCodeGen;
import org.eclipse.papyrus.C_Cpp.Template;
import org.eclipse.papyrus.codegen.base.GenUtils;
import org.eclipse.papyrus.codegen.base.ILocationStrategy;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;
import org.eclipse.papyrus.codegen.base.ModelElementsCreator;
import org.eclipse.papyrus.codegen.base.ProjectBasedFileAccess;
import org.eclipse.papyrus.cpp.codegen.Activator;
import org.eclipse.papyrus.cpp.codegen.Messages;
import org.eclipse.papyrus.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.cpp.codegen.transformation.CppLocationStrategy;
import org.eclipse.papyrus.cpp.codegen.xtend.CppClassifierGenerator;
import org.eclipse.papyrus.cpp.codegen.xtend.CppPackageHeaderGenerator;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CppModelElementsCreator
extends ModelElementsCreator {
    protected String hppExt;
    protected String cppExt;
    protected String commentHeader;

    public CppModelElementsCreator(IProject project) {
        this((IPFileSystemAccess)new ProjectBasedFileAccess(project), null);
    }

    public CppModelElementsCreator(IProject project, String commentHeader) {
        this((IPFileSystemAccess)new ProjectBasedFileAccess(project), commentHeader);
    }

    public CppModelElementsCreator(IPFileSystemAccess fileSystemAccess, String commentHeader) {
        super(fileSystemAccess, (ILocationStrategy)new CppLocationStrategy());
        this.commentHeader = commentHeader != null ? commentHeader : CppCodeGenUtils.getCommentHeader();
        this.hppExt = CppCodeGenUtils.getHeaderSuffix();
        this.cppExt = CppCodeGenUtils.getBodySuffix();
    }

    protected void createPackageableElementFile(PackageableElement element, IProgressMonitor monitor) {
        if (element instanceof Package) {
            this.generatePkg((Package)element);
        } else if (!(element instanceof PrimitiveType || element instanceof Enumeration || element instanceof Usage)) {
            if (element instanceof Classifier) {
                this.generateClassifier((Classifier)element);
            } else if (!(element instanceof Relationship || element instanceof Signal || element instanceof SignalEvent)) {
                Activator.log.debug("C++ code generator: unsupported model element " + element);
            }
        }
    }

    protected void generateClassifier(Classifier classifier) {
        if (GenUtils.hasStereotype((Element)classifier, ManualGeneration.class)) {
            ManualGeneration mg = (ManualGeneration)UMLUtil.getStereotypeApplication((Element)classifier, ManualGeneration.class);
            Include cppInclude = (Include)UMLUtil.getStereotypeApplication((Element)classifier, Include.class);
            String fileContentH = String.valueOf(this.commentHeader) + cppInclude.getHeader();
            String fileNameH = String.valueOf(this.locStrategy.getFileName((NamedElement)classifier)) + "." + this.hppExt;
            this.generateFile(fileNameH, fileContentH);
            String fileContentB = String.valueOf(this.commentHeader) + cppInclude.getPreBody() + GenUtils.NL + cppInclude.getBody() + GenUtils.NL;
            String ext = GenUtils.maskNull((String)mg.getExtensionBody());
            if (ext.length() == 0) {
                ext = this.cppExt;
            }
            String fileNameB = String.valueOf(this.locStrategy.getFileName((NamedElement)classifier)) + "." + ext;
            this.generateFile(fileNameB, fileContentB);
        } else if (!(this.noCodeGen((Element)classifier) || GenUtils.hasStereotype((Element)classifier, Template.class) || classifier instanceof Association)) {
            if (GenUtils.isTemplateBoundElement((Classifier)classifier)) {
                String bindHeaderFileName = String.valueOf(this.locStrategy.getFileName((NamedElement)classifier)) + "." + this.hppExt;
                this.generateFile(bindHeaderFileName, String.valueOf(this.commentHeader) + CppClassifierGenerator.generateBindHeaderCode(classifier));
                String bindBodyFileName = String.valueOf(this.locStrategy.getFileName((NamedElement)classifier)) + "." + this.cppExt;
                this.generateFile(bindBodyFileName, String.valueOf(this.commentHeader) + CppClassifierGenerator.generateBindBodyCode(classifier));
            } else {
                String classHeaderFileName = String.valueOf(this.locStrategy.getFileName((NamedElement)classifier)) + "." + this.hppExt;
                this.generateFile(classHeaderFileName, String.valueOf(this.commentHeader) + CppClassifierGenerator.generateClassHeaderCode(classifier));
                if (classifier instanceof Class) {
                    String classBodyFileName = String.valueOf(this.locStrategy.getFileName((NamedElement)classifier)) + "." + this.cppExt;
                    this.generateFile(classBodyFileName, String.valueOf(this.commentHeader) + CppClassifierGenerator.generateClassBodyCode(classifier));
                }
            }
        }
    }

    protected void generatePkg(Package pkg) {
        String fileName = String.valueOf(this.locStrategy.getFileName((NamedElement)pkg)) + "." + this.hppExt;
        this.generateFile(fileName, CppPackageHeaderGenerator.generateCode(pkg).toString());
    }

    protected void generateFile(String fileName, String content) {
        this.fileSystemAccess.generateFile(fileName, CppModelElementsCreator.format(content));
    }

    private static String format(String content) {
        Document doc;
        if (Platform.getBundle((String)"org.eclipse.cdt.core") == null) {
            return content;
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(null);
        TextEdit edit = codeFormatter.format(8, (doc = new Document(content)).get(), 0, doc.get().length(), 0, null);
        if (edit == null) {
            Activator.log.debug(Messages.CppModelElementsCreator_CannotFormatContent);
            return content;
        }
        try {
            edit.apply((IDocument)doc);
            return doc.get();
        }
        catch (MalformedTreeException e) {
            Activator.log.error((Throwable)e);
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
        }
        return content;
    }

    protected boolean noCodeGen(Element element) {
        return GenUtils.hasStereotype((Element)element, NoCodeGen.class) || GenUtils.hasStereotype((Element)element, External.class) || GenUtils.hasStereotypeTree((Element)element, ExternLibrary.class);
    }
}

