/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cpp.codegen.utils;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.papyrus.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.C_Cpp.External;
import org.eclipse.papyrus.C_Cpp.NoCodeGen;
import org.eclipse.papyrus.C_Cpp.Typedef;
import org.eclipse.papyrus.C_Cpp.Visibility;
import org.eclipse.papyrus.codegen.base.GenUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.ConnectableElementTemplateParameter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OperationTemplateParameter;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CppGenUtils {
    public static final String ANSI_C_LIB = "AnsiCLibrary";
    private static Namespace currentNS;
    private static VisibilityKind currVisibility;
    private static final Pattern EmptySectionRegex;

    static {
        currVisibility = null;
        EmptySectionRegex = Pattern.compile("^\\s*$");
    }

    public static String getTemplateParametersWoType(Classifier classifier) {
        String tparamWoType = "";
        Iterator it = GenUtils.getTemplateParameters((Classifier)classifier).iterator();
        while (it.hasNext()) {
            TemplateParameter currentTParam = (TemplateParameter)it.next();
            tparamWoType = String.valueOf(tparamWoType) + GenUtils.getTemplateName((TemplateParameter)currentTParam);
            if (!it.hasNext()) continue;
            tparamWoType = String.valueOf(tparamWoType) + ", ";
        }
        return tparamWoType;
    }

    public static String getStdtypes(PrimitiveType type) {
        Element owner = type.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (owningPkgName.equals("PrimitiveTypes") || owningPkgName.equals("UMLPrimitiveTypes") || owningPkgName.equals("MARTE_PrimitivesTypes")) {
            String td = null;
            String name = type.getName();
            if (name.equals("Boolean")) {
                td = "bool";
            } else if (name.equals("Integer")) {
                td = "int";
            } else if (name.equals("Unlimited Natural")) {
                td = "unsigned long";
            } else if (name.equals("Real")) {
                td = "float";
            } else if (name.equals("String")) {
                td = "const char *";
            } else if (name.equals("Unlimited Natural")) {
                td = "unsigned long";
            }
            if (td != null) {
                return "typedef " + td + " " + name + ";";
            }
        }
        return "";
    }

    public static String cppQualifiedName(NamedElement ne) {
        if (ne == null) {
            return "undefined";
        }
        Element owner = ne.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (GenUtils.hasStereotype((Element)ne, External.class) || GenUtils.hasStereotypeTree((Element)ne, NoCodeGen.class) || GenUtils.hasStereotypeTree((Element)ne, ExternLibrary.class)) {
            return ne.getName();
        }
        if (owningPkgName.equals(ANSI_C_LIB)) {
            return ne.getName();
        }
        if (owner instanceof ClassifierTemplateParameter) {
            return ne.getName();
        }
        String qName = ne.getName();
        if (currentNS == ne.getNamespace()) {
            return qName;
        }
        if (ne instanceof PrimitiveType && !GenUtils.hasStereotype((Element)ne, Typedef.class) && CppGenUtils.getStdtypes((PrimitiveType)ne).length() == 0) {
            return qName;
        }
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null && ns.getName().equals("root")) continue;
            qName = String.valueOf(ns.getName()) + "::" + qName;
        }
        if (qName.contains("::")) {
            return "::" + qName;
        }
        return qName;
    }

    public static String getTemplateTypeName(TemplateParameter templateParam) {
        String prefix = "";
        String name = "";
        ParameterableElement pElt = templateParam.getParameteredElement();
        if (pElt != null && pElt instanceof NamedElement) {
            name = ((NamedElement)pElt).getName();
            if (templateParam instanceof ClassifierTemplateParameter) {
                prefix = "class ";
            } else if (!(templateParam instanceof OperationTemplateParameter) && !(templateParam instanceof ConnectableElementTemplateParameter)) {
                prefix = pElt instanceof LiteralInteger ? "int " : (pElt instanceof LiteralString ? "String " : (pElt instanceof LiteralBoolean ? "Boolean " : (pElt instanceof LiteralUnlimitedNatural ? "UnlimitedNatural " : String.valueOf(pElt.eClass().getName()) + " ")));
            }
        } else {
            name = "undefined";
        }
        return String.valueOf(prefix) + name;
    }

    public static String getNamespace(NamedElement ne) {
        String namespace = "";
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null) continue;
            String nsName = ns.getName();
            if (!namespace.equals("")) {
                nsName = String.valueOf(nsName) + "::";
            }
            namespace = String.valueOf(nsName) + namespace;
        }
        if (!namespace.equals("")) {
            namespace = "\nusing namespace " + namespace + ";\n";
        }
        return namespace;
    }

    public static String openNS(NamedElement ne) {
        String openNS = "";
        currentNS = ne.getNamespace();
        if (ne instanceof Package) {
            openNS = "namespace " + ne.getName() + " {\n";
        }
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null) continue;
            openNS = "namespace " + ns.getName() + " {\n" + openNS;
        }
        return openNS;
    }

    public static String closeNS(NamedElement ne) {
        String closeNS = "";
        if (ne instanceof Package) {
            closeNS = "} // of namespace " + ne.getName() + "\n";
        }
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null) continue;
            closeNS = String.valueOf(closeNS) + "} // of namespace " + ns.getName() + "\n";
        }
        return closeNS;
    }

    public static String getGeneralizationVisibility(Element element) {
        Visibility cppVisibility = (Visibility)UMLUtil.getStereotypeApplication((Element)element, Visibility.class);
        if (cppVisibility != null) {
            return cppVisibility.getValue();
        }
        return "public";
    }

    public static void resetVisibility(VisibilityKind v) {
        currVisibility = v;
    }

    public static String getSection(VisibilityKind visibility, String content) {
        VisibilityKind newVisibility = null;
        if (!visibility.equals((Object)currVisibility)) {
            newVisibility = visibility;
        }
        Matcher m = EmptySectionRegex.matcher(content);
        if (content.isEmpty() || m.matches()) {
            return "";
        }
        if (newVisibility == null) {
            return content;
        }
        currVisibility = newVisibility;
        return String.valueOf(currVisibility.toString()) + ":\n" + content;
    }
}

