/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dg.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.dd.dg.DGFactory;
import org.eclipse.papyrus.dd.dg.DGPackage;
import org.eclipse.papyrus.dd.dg.GraphicalElement;
import org.eclipse.papyrus.dd.dg.provider.DefinitionItemProvider;

public class GraphicalElementItemProvider
extends DefinitionItemProvider {
    public GraphicalElementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addClipPathPropertyDescriptor(object);
            this.addClassPropertyDescriptor(object);
            this.addLayoutDataPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addClipPathPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_GraphicalElement_clipPath_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_GraphicalElement_clipPath_feature", "_UI_GraphicalElement_type"), (EStructuralFeature)DGPackage.Literals.GRAPHICAL_ELEMENT__CLIP_PATH, true, false, true, null, null, null));
    }

    protected void addClassPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_GraphicalElement_class_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_GraphicalElement_class_feature", "_UI_GraphicalElement_type"), (EStructuralFeature)DGPackage.Literals.GRAPHICAL_ELEMENT__CLASS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addLayoutDataPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_GraphicalElement_layoutData_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_GraphicalElement_layoutData_feature", "_UI_GraphicalElement_type"), (EStructuralFeature)DGPackage.Literals.GRAPHICAL_ELEMENT__LAYOUT_DATA, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(DGPackage.Literals.GRAPHICAL_ELEMENT__STYLE);
            this.childrenFeatures.add(DGPackage.Literals.GRAPHICAL_ELEMENT__TRANSFORM);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public String getText(Object object) {
        String label = this.getLabel((GraphicalElement)object);
        return label == null || label.length() == 0 ? this.getString("_UI_GraphicalElement_type") : String.valueOf(this.getString("_UI_GraphicalElement_type")) + " " + label;
    }

    protected String getLabel(GraphicalElement element) {
        String label = "";
        if (element.getId() != null) {
            label = String.valueOf(label) + "id=" + element.getId();
        }
        if (!element.getClasses().isEmpty()) {
            if (label.length() > 0) {
                label = String.valueOf(label) + ", ";
            }
            label = String.valueOf(label) + this.joinString("class", (Collection<String>)element.getClasses(), ",");
        }
        return label.length() > 0 ? "[" + label + "]" : "";
    }

    private String joinString(String key, Collection<String> values, String sep) {
        String s = "";
        for (String v : values) {
            s = String.valueOf(s) + (s.length() > 0 ? ", " + v : v);
        }
        return String.valueOf(key) + "=" + s;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(GraphicalElement.class)) {
            case 3: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(DGPackage.Literals.GRAPHICAL_ELEMENT__STYLE, DGFactory.eINSTANCE.createStyle()));
        newChildDescriptors.add(this.createChildParameter(DGPackage.Literals.GRAPHICAL_ELEMENT__TRANSFORM, DGFactory.eINSTANCE.createMatrix()));
        newChildDescriptors.add(this.createChildParameter(DGPackage.Literals.GRAPHICAL_ELEMENT__TRANSFORM, DGFactory.eINSTANCE.createRotate()));
        newChildDescriptors.add(this.createChildParameter(DGPackage.Literals.GRAPHICAL_ELEMENT__TRANSFORM, DGFactory.eINSTANCE.createScale()));
        newChildDescriptors.add(this.createChildParameter(DGPackage.Literals.GRAPHICAL_ELEMENT__TRANSFORM, DGFactory.eINSTANCE.createSkew()));
        newChildDescriptors.add(this.createChildParameter(DGPackage.Literals.GRAPHICAL_ELEMENT__TRANSFORM, DGFactory.eINSTANCE.createTranslate()));
    }
}

