/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dg.presentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.dd.dg.RootCanvas;
import org.eclipse.papyrus.dd.dg.presentation.DGEditor;
import org.eclipse.papyrus.dd.dg.presentation.DGToSVGConverter;
import org.eclipse.papyrus.dd.presentation.DDEditorPage;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DGSVGCanvasPage
extends DDEditorPage {
    public static final String ID = DGSVGCanvasPage.class.getName();
    protected SVGCanvasViewer viewer;

    public DGSVGCanvasPage(DGEditor editor) {
        super(editor, ID, DGSVGCanvasPage.getString("DGSVGCanvasPage.title"));
    }

    @Override
    protected Viewer createViewer(Composite formBody) {
        this.viewer = new SVGCanvasViewer(formBody);
        return this.viewer;
    }

    @Override
    public void refresh() {
        RootCanvas canvas = (RootCanvas)this.getDDEditor().getSelectedEObject();
        if (canvas == null) {
            this.viewer.setInput(null);
            return;
        }
        Document svgDocument = this.getConverter().convert(canvas);
        this.viewer.setInput(svgDocument);
    }

    protected DGToSVGConverter getConverter() {
        return new DGToSVGConverter();
    }

    public static class SVGCanvasViewer
    extends Viewer {
        private Composite composite;
        private JSVGCanvas svgCanvas;

        public SVGCanvasViewer(Composite parent) {
            this.composite = new Composite(parent, 0x1000000);
            Frame frame = SWT_AWT.new_Frame((Composite)this.composite);
            frame.setVisible(true);
            this.svgCanvas = new JSVGCanvas();
            this.svgCanvas.setDocumentState(1);
            JSVGScrollPane pane = new JSVGScrollPane(this.svgCanvas);
            frame.add((Component)pane);
        }

        public Control getControl() {
            return this.composite;
        }

        public Object getInput() {
            return this.svgCanvas.getSVGDocument();
        }

        public void setInput(final Object input) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Document doc = (Document)input;
                    SVGCanvasViewer.this.svgCanvas.setDocument(doc);
                    Element svg = doc.getDocumentElement();
                    String value = svg.getAttribute("background-color");
                    if (value != null && value.length() > 0) {
                        SVGCanvasViewer.this.svgCanvas.setBackground(Color.decode(value));
                    } else {
                        SVGCanvasViewer.this.svgCanvas.setBackground(Color.white);
                    }
                }
            });
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void refresh() {
        }

        public void setSelection(ISelection selection, boolean reveal) {
        }
    }
}

