/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dg.presentation;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.transcoder.svg2svg.PrettyPrinter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.dd.dg.RootCanvas;
import org.eclipse.papyrus.dd.dg.presentation.DGEditor;
import org.eclipse.papyrus.dd.dg.presentation.DGToSVGConverter;
import org.eclipse.papyrus.dd.presentation.DDEditorPage;
import org.eclipse.papyrus.dd.presentation.DDEditorPlugin;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.DOMImplementation;

public class DGSVGSourcePage
extends DDEditorPage {
    public static final String ID = DGSVGSourcePage.class.getName();
    protected SourceViewer viewer;

    public DGSVGSourcePage(DGEditor editor) {
        super(editor, ID, DGSVGSourcePage.getString("DGSVGSourcePage.title"));
    }

    @Override
    protected Viewer createViewer(Composite formBody) {
        this.viewer = new SourceViewer(formBody, null, 768);
        this.viewer.getTextWidget().setAlwaysShowScrollBars(false);
        this.viewer.setEditable(false);
        return this.viewer;
    }

    @Override
    public void refresh() {
        String contents;
        RootCanvas canvas = (RootCanvas)this.getDDEditor().getSelectedEObject();
        if (canvas == null) {
            this.viewer.setDocument(null);
            return;
        }
        org.w3c.dom.Document svgDocument = this.getConverter().convert(canvas);
        try {
            StringWriter writer = new StringWriter();
            DOMUtilities.writeDocument((org.w3c.dom.Document)svgDocument, (Writer)writer);
            StringWriter formatted = new StringWriter();
            PrettyPrinter printer = new PrettyPrinter();
            printer.setTabulationWidth(4);
            printer.setDocumentWidth(2000);
            printer.print((Reader)new StringReader(writer.toString()), (Writer)formatted);
            contents = formatted.toString().substring(1);
            writer.close();
        }
        catch (Exception e) {
            DDEditorPlugin.INSTANCE.log(e);
            return;
        }
        Document document = new Document();
        document.set(contents);
        this.viewer.setDocument((IDocument)document);
    }

    protected DGToSVGConverter getConverter() {
        return new DGToSVGConverter(){

            @Override
            protected DOMImplementation getDOMImplementation() {
                return GenericDOMImplementation.getDOMImplementation();
            }
        };
    }
}

