/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dg.presentation;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGSyntax;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.dd.dc.Bounds;
import org.eclipse.papyrus.dd.dc.DCPackage;
import org.eclipse.papyrus.dd.dc.Dimension;
import org.eclipse.papyrus.dd.dc.Point;
import org.eclipse.papyrus.dd.dg.Canvas;
import org.eclipse.papyrus.dd.dg.Circle;
import org.eclipse.papyrus.dd.dg.ClipPath;
import org.eclipse.papyrus.dd.dg.ClosePath;
import org.eclipse.papyrus.dd.dg.CubicCurveTo;
import org.eclipse.papyrus.dd.dg.DGPackage;
import org.eclipse.papyrus.dd.dg.Definition;
import org.eclipse.papyrus.dd.dg.Definitions;
import org.eclipse.papyrus.dd.dg.Ellipse;
import org.eclipse.papyrus.dd.dg.EllipticalArcTo;
import org.eclipse.papyrus.dd.dg.FontDecoration;
import org.eclipse.papyrus.dd.dg.Gradient;
import org.eclipse.papyrus.dd.dg.GradientStop;
import org.eclipse.papyrus.dd.dg.GraphicalElement;
import org.eclipse.papyrus.dd.dg.Group;
import org.eclipse.papyrus.dd.dg.Image;
import org.eclipse.papyrus.dd.dg.Line;
import org.eclipse.papyrus.dd.dg.LineTo;
import org.eclipse.papyrus.dd.dg.LinearGradient;
import org.eclipse.papyrus.dd.dg.MarkedElement;
import org.eclipse.papyrus.dd.dg.Marker;
import org.eclipse.papyrus.dd.dg.Matrix;
import org.eclipse.papyrus.dd.dg.MoveTo;
import org.eclipse.papyrus.dd.dg.Paint;
import org.eclipse.papyrus.dd.dg.PaintServer;
import org.eclipse.papyrus.dd.dg.Path;
import org.eclipse.papyrus.dd.dg.PathCommand;
import org.eclipse.papyrus.dd.dg.Pattern;
import org.eclipse.papyrus.dd.dg.Polygon;
import org.eclipse.papyrus.dd.dg.Polyline;
import org.eclipse.papyrus.dd.dg.QuadraticCurveTo;
import org.eclipse.papyrus.dd.dg.RadialGradient;
import org.eclipse.papyrus.dd.dg.Rectangle;
import org.eclipse.papyrus.dd.dg.RootCanvas;
import org.eclipse.papyrus.dd.dg.Rotate;
import org.eclipse.papyrus.dd.dg.Scale;
import org.eclipse.papyrus.dd.dg.Skew;
import org.eclipse.papyrus.dd.dg.Style;
import org.eclipse.papyrus.dd.dg.StyleRule;
import org.eclipse.papyrus.dd.dg.StyleSelector;
import org.eclipse.papyrus.dd.dg.StyleSheet;
import org.eclipse.papyrus.dd.dg.Text;
import org.eclipse.papyrus.dd.dg.TextAnchor;
import org.eclipse.papyrus.dd.dg.Transform;
import org.eclipse.papyrus.dd.dg.Translate;
import org.eclipse.papyrus.dd.dg.Use;
import org.eclipse.papyrus.dd.dg.util.DGSwitch;
import org.eclipse.papyrus.dd.presentation.DDEditorPlugin;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class DGToSVGConverter
extends DGSwitch<Object>
implements SVGSyntax {
    public static final String SVG_BACKGROUND_COLOR_ATTRIBUTE = "background-color";
    public static final String SVG_TEXT_DECORATION_ATTRIBUTE = "text-decoration";
    public static final String SVG_MARKER_START_ATTRIBUTE = "marker-start";
    public static final String SVG_MARKER_MID_ATTRIBUTE = "marker-mid";
    public static final String SVG_MARKER_END_ATTRIBUTE = "marker-end";
    public static final String SVG_LAYOUT_ATTRIBUTE = "layout";
    public static final String SVG_LAYOUT_DATA_ATTRIBUTE = "layoutData";
    private Resource resource;
    private Document svgDocument;
    private Map<EObject, Object> cache = new HashMap<EObject, Object>();

    public Document convert(RootCanvas canvas) {
        if (canvas == null) {
            return null;
        }
        this.resource = canvas.eResource();
        DOMImplementation impl = this.getDOMImplementation();
        this.svgDocument = impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.svgDocument.setDocumentURI(this.resource.getURI().toString());
        TreeIterator iterator = canvas.eAllContents();
        while (iterator.hasNext()) {
            this.doSwitch((EObject)iterator.next());
        }
        return this.svgDocument;
    }

    protected DOMImplementation getDOMImplementation() {
        return SVGDOMImplementation.getDOMImplementation();
    }

    protected String convertColorToString(Color c) {
        return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    protected String convertDoubleToString(Double d) {
        return String.valueOf(d);
    }

    protected String convertReferenceToURI(Definition referenced) {
        Resource referencedResource = referenced.eResource();
        URI uri = referencedResource.getURI();
        String uriFragment = referenced.getId();
        if (this.resource.equals(referencedResource)) {
            return String.valueOf('#') + uriFragment;
        }
        return uri.appendFragment(uriFragment).toString();
    }

    protected String convertReferenceToURL(Definition reference) {
        return "url(" + this.convertReferenceToURI(reference) + ")";
    }

    protected <S> S map(EObject theEObject, S object) {
        this.cache.put(theEObject, object);
        return object;
    }

    protected Object lookup(EObject theEObject) {
        return this.cache.get(theEObject);
    }

    protected Element getParentElement(EObject child) {
        return (Element)this.doSwitch(child.eContainer());
    }

    public Object doSwitch(EObject theEObject) {
        Object value = this.cache.containsKey(theEObject) ? this.cache.get(theEObject) : super.doSwitch(theEObject);
        return value instanceof StringBuffer ? value.toString() : value;
    }

    public Object defaultCase(EObject object) {
        return this.cache.get(object);
    }

    public Object caseCanvas(Canvas object) {
        Element svg = (Element)this.lookup((EObject)object);
        if (svg == null) {
            svg = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "svg"));
            this.getParentElement((EObject)object).appendChild(svg);
        }
        svg.setAttribute("overflow", "visible");
        if (object.getBounds() != null) {
            Bounds bounds = object.getBounds();
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__X)) {
                svg.setAttribute("x", this.convertDoubleToString(bounds.getX()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__Y)) {
                svg.setAttribute("y", this.convertDoubleToString(bounds.getY()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__WIDTH)) {
                svg.setAttribute("width", this.convertDoubleToString(bounds.getWidth()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__HEIGHT)) {
                svg.setAttribute("height", this.convertDoubleToString(bounds.getHeight()));
            }
        }
        return super.caseCanvas(object);
    }

    public Object caseCircle(Circle object) {
        Element circle = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "circle"));
        this.getParentElement((EObject)object).appendChild(circle);
        if (object.getCenter() != null) {
            Point center = object.getCenter();
            if (center.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                circle.setAttribute("cx", this.convertDoubleToString(center.getX()));
            }
            if (center.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                circle.setAttribute("cy", this.convertDoubleToString(center.getY()));
            }
        }
        circle.setAttribute("r", this.convertDoubleToString(object.getRadius()));
        return super.caseCircle(object);
    }

    public Object caseClipPath(ClipPath object) {
        Element clipPath = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "clipPath"));
        this.getParentElement((EObject)object).appendChild(clipPath);
        clipPath.setAttribute("clipPathUnits", "objectBoundingBox");
        return super.caseClipPath(object);
    }

    public Object caseClosePath(ClosePath object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append(object.isRelative() ? "z" : "Z");
        return super.caseClosePath(object);
    }

    public Object caseCubicCurveTo(CubicCurveTo object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append(object.isRelative() ? "c" : "C");
        if (object.getStartControl() != null) {
            Point start = object.getStartControl();
            sb.append(String.valueOf(this.convertDoubleToString(start.getX())) + "," + this.convertDoubleToString(start.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        sb.append(" ");
        if (object.getEndControl() != null) {
            Point end = object.getEndControl();
            sb.append(String.valueOf(this.convertDoubleToString(end.getX())) + "," + this.convertDoubleToString(end.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        sb.append(" ");
        if (object.getPoint() != null) {
            Point point = object.getPoint();
            sb.append(String.valueOf(this.convertDoubleToString(point.getX())) + "," + this.convertDoubleToString(point.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        return super.caseCubicCurveTo(object);
    }

    public Object caseDefinition(Definition object) {
        Element definition = (Element)this.lookup((EObject)object);
        if (object.getId() != null) {
            definition.setAttribute("id", object.getId());
        }
        return super.caseDefinition(object);
    }

    public Object caseDefinitions(Definitions object) {
        Element defs = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "defs"));
        this.getParentElement((EObject)object).appendChild(defs);
        return super.caseDefinitions(object);
    }

    public Object caseEllipse(Ellipse object) {
        Element ellipse = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "ellipse"));
        this.getParentElement((EObject)object).appendChild(ellipse);
        if (object.getCenter() != null) {
            Point center = object.getCenter();
            if (center.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                ellipse.setAttribute("cx", this.convertDoubleToString(center.getX()));
            }
            if (center.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                ellipse.setAttribute("cy", this.convertDoubleToString(center.getY()));
            }
        }
        if (object.getRadii() != null) {
            Dimension radii = object.getRadii();
            ellipse.setAttribute("rx", this.convertDoubleToString(radii.getWidth()));
            ellipse.setAttribute("ry", this.convertDoubleToString(radii.getHeight()));
        } else {
            ellipse.setAttribute("rx", "0.0");
            ellipse.setAttribute("ry", "0.0");
        }
        return super.caseEllipse(object);
    }

    public Object caseEllipticalArcTo(EllipticalArcTo object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append(object.isRelative() ? "a" : "A");
        if (object.getRadii() != null) {
            Dimension radii = object.getRadii();
            sb.append(String.valueOf(this.convertDoubleToString(radii.getWidth())) + "," + this.convertDoubleToString(radii.getHeight()));
        } else {
            sb.append("0.0,0.0");
        }
        sb.append(" ");
        sb.append(this.convertDoubleToString(object.getRotation()));
        sb.append(" ");
        sb.append(object.isLargeArc() ? "1" : "0");
        sb.append(",");
        sb.append(object.isSweep() ? "1" : "0");
        sb.append(" ");
        if (object.getPoint() != null) {
            Point point = object.getPoint();
            sb.append(String.valueOf(this.convertDoubleToString(point.getX())) + "," + this.convertDoubleToString(point.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        return super.casePathCommand((PathCommand)object);
    }

    public Object caseGradient(Gradient object) {
        Element gradient = (Element)this.lookup((EObject)object);
        if (gradient != null && object.getTransforms().size() > 0) {
            String transforms = "";
            for (Transform transform : object.getTransforms()) {
                transforms = String.valueOf(transforms) + (transforms.length() > 0 ? " " : "");
                transforms = String.valueOf(transforms) + (String)this.doSwitch((EObject)transform);
            }
            gradient.setAttribute("gradientTransform", transforms);
        }
        return super.caseGradient(object);
    }

    public Object caseGradientStop(GradientStop object) {
        Element stop = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "stop"));
        this.getParentElement((EObject)object).appendChild(stop);
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.GRADIENT_STOP__OFFSET)) {
            stop.setAttribute("offset", String.valueOf(this.convertDoubleToString(object.getOffset())) + "%");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.GRADIENT_STOP__COLOR)) {
            stop.setAttribute("stop-color", this.convertColorToString(object.getColor()));
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.GRADIENT_STOP__OPACITY)) {
            stop.setAttribute("stop-opacity", this.convertDoubleToString(object.getOpacity()));
        }
        return super.caseGradientStop(object);
    }

    public Object caseGraphicalElement(GraphicalElement object) {
        Element element = (Element)this.lookup((EObject)object);
        if (element != null) {
            if (object.getClasses().size() > 0) {
                String classes = "";
                for (String class_ : object.getClasses()) {
                    classes = String.valueOf(classes) + (classes.length() > 0 ? ", " : "");
                    classes = String.valueOf(classes) + class_;
                }
                element.setAttribute("class", classes);
            }
            if (object.getStyle() != null) {
                String value = (String)this.doSwitch((EObject)object.getStyle());
                element.setAttribute("style", value);
            }
            if (object.getClipPath() != null) {
                element.setAttribute("clip-path", this.convertReferenceToURL((Definition)object.getClipPath()));
            }
            if (object.getTransforms().size() > 0) {
                String transforms = "";
                for (Transform transform : object.getTransforms()) {
                    transforms = String.valueOf(transforms) + (transforms.length() > 0 ? " " : "");
                    transforms = String.valueOf(transforms) + (String)this.doSwitch((EObject)transform);
                }
                element.setAttribute("transform", transforms);
            }
            if (object.getLayoutData() != null) {
                element.setAttribute(SVG_LAYOUT_DATA_ATTRIBUTE, object.getLayoutData());
            }
        }
        return super.caseGraphicalElement(object);
    }

    public Object caseGroup(Group object) {
        Element g = (Element)this.lookup((EObject)object);
        if (g == null) {
            g = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "g"));
            this.getParentElement((EObject)object).appendChild(g);
        }
        if (object.getLayout() != null) {
            g.setAttribute(SVG_LAYOUT_ATTRIBUTE, object.getLayout());
        }
        return super.caseGroup(object);
    }

    public Object caseImage(Image object) {
        Element image = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "image"));
        this.getParentElement((EObject)object).appendChild(image);
        if (object.getBounds() != null) {
            Bounds bounds = object.getBounds();
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__X)) {
                image.setAttribute("x", this.convertDoubleToString(bounds.getX()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__Y)) {
                image.setAttribute("y", this.convertDoubleToString(bounds.getY()));
            }
            image.setAttribute("width", this.convertDoubleToString(bounds.getWidth()));
            image.setAttribute("height", this.convertDoubleToString(bounds.getHeight()));
        } else {
            image.setAttribute("width", "0.0");
            image.setAttribute("height", "0.0");
        }
        if (object.getSource() != null && object.getSource().length() > 0) {
            image.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", object.getSource());
        } else {
            image.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "http://missing.reference");
        }
        String preserve = object.isAspectRatioPreserved() ? "xMidYMid meet" : "none";
        image.setAttribute("preserveAspectRatio", preserve);
        return super.caseImage(object);
    }

    public Object caseLine(Line object) {
        Element line = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "line"));
        this.getParentElement((EObject)object).appendChild(line);
        if (object.getStart() != null) {
            Point start = object.getStart();
            if (start.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                line.setAttribute("x1", this.convertDoubleToString(start.getX()));
            }
            if (start.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                line.setAttribute("y1", this.convertDoubleToString(start.getY()));
            }
        }
        if (object.getEnd() != null) {
            Point end = object.getEnd();
            if (end.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                line.setAttribute("x2", this.convertDoubleToString(end.getX()));
            }
            if (end.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                line.setAttribute("y2", this.convertDoubleToString(end.getY()));
            }
        }
        return super.caseLine(object);
    }

    public Object caseLinearGradient(LinearGradient object) {
        Element gradient = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "linearGradient"));
        this.getParentElement((EObject)object).appendChild(gradient);
        gradient.setAttribute("gradientUnits", "objectBoundingBox");
        if (object.getStart() != null) {
            Point start = object.getStart();
            if (start.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                gradient.setAttribute("x1", String.valueOf(this.convertDoubleToString(start.getX())) + "%");
            }
            if (start.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                gradient.setAttribute("y1", String.valueOf(this.convertDoubleToString(start.getY())) + "%");
            }
        }
        if (object.getEnd() != null) {
            Point end = object.getEnd();
            if (end.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                gradient.setAttribute("x2", String.valueOf(this.convertDoubleToString(end.getX())) + "%");
            }
            if (end.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                gradient.setAttribute("y2", String.valueOf(this.convertDoubleToString(end.getY())) + "%");
            }
        }
        return super.caseLinearGradient(object);
    }

    public Object caseLineTo(LineTo object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append(object.isRelative() ? "l" : "L");
        if (object.getPoint() != null) {
            Point point = object.getPoint();
            sb.append(String.valueOf(this.convertDoubleToString(point.getX())) + "," + this.convertDoubleToString(point.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        return super.caseLineTo(object);
    }

    public Object caseMarkedElement(MarkedElement object) {
        Element element = (Element)this.lookup((EObject)object);
        if (element != null) {
            if (object.getStartMarker() != null) {
                element.setAttribute(SVG_MARKER_START_ATTRIBUTE, this.convertReferenceToURL((Definition)object.getStartMarker()));
            }
            if (object.getMidMarker() != null) {
                element.setAttribute(SVG_MARKER_MID_ATTRIBUTE, this.convertReferenceToURL((Definition)object.getMidMarker()));
            }
            if (object.getEndMarker() != null) {
                element.setAttribute(SVG_MARKER_END_ATTRIBUTE, this.convertReferenceToURL((Definition)object.getEndMarker()));
            }
        }
        return super.caseMarkedElement(object);
    }

    public Object caseMarker(Marker object) {
        Element marker = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "marker"));
        this.getParentElement((EObject)object).appendChild(marker);
        marker.setAttribute("markerUnits", "strokeWidth");
        marker.setAttribute("orient", "auto");
        if (object.getSize() != null) {
            Dimension size = object.getSize();
            if (size.eIsSet((EStructuralFeature)DCPackage.Literals.DIMENSION__WIDTH)) {
                marker.setAttribute("markerWidth", this.convertDoubleToString(size.getWidth()));
            }
            if (size.eIsSet((EStructuralFeature)DCPackage.Literals.DIMENSION__HEIGHT)) {
                marker.setAttribute("markerHeight", this.convertDoubleToString(size.getHeight()));
            }
        }
        if (object.getReference() != null) {
            Point reference = object.getReference();
            if (reference.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                marker.setAttribute("refX", this.convertDoubleToString(reference.getX()));
            }
            if (reference.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                marker.setAttribute("refY", this.convertDoubleToString(reference.getY()));
            }
        }
        return super.caseMarker(object);
    }

    public Object caseMatrix(Matrix object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append("matrix(");
        sb.append(this.convertDoubleToString(object.getA()));
        sb.append(", ");
        sb.append(this.convertDoubleToString(object.getB()));
        sb.append(", ");
        sb.append(this.convertDoubleToString(object.getC()));
        sb.append(", ");
        sb.append(this.convertDoubleToString(object.getD()));
        sb.append(", ");
        sb.append(this.convertDoubleToString(object.getE()));
        sb.append(", ");
        sb.append(this.convertDoubleToString(object.getF()));
        sb.append(")");
        return super.caseMatrix(object);
    }

    public Object caseMoveTo(MoveTo object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append(object.isRelative() ? "m" : "M");
        if (object.getPoint() != null) {
            Point point = object.getPoint();
            sb.append(String.valueOf(this.convertDoubleToString(point.getX())) + "," + this.convertDoubleToString(point.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        return super.caseMoveTo(object);
    }

    public Object casePaint(Paint object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.PAINT__COLOR)) {
            sb.append(this.convertColorToString(object.getColor()));
        } else if (object.getPaintServer() != null) {
            sb.append(this.convertReferenceToURL((Definition)object.getPaintServer()));
        } else {
            sb.append("none");
        }
        return super.casePaint(object);
    }

    public Object casePaintServer(PaintServer object) {
        return super.casePaintServer(object);
    }

    public Object casePath(Path object) {
        Element path = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "path"));
        this.getParentElement((EObject)object).appendChild(path);
        if (!object.getCommands().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (PathCommand command : object.getCommands()) {
                String c = (String)this.doSwitch((EObject)command);
                sb.append(sb.length() > 0 ? " " : "");
                sb.append(c);
            }
            path.setAttribute("d", sb.toString());
        }
        return super.casePath(object);
    }

    public Object casePathCommand(PathCommand object) {
        return super.casePathCommand(object);
    }

    public Object casePattern(Pattern object) {
        Element pattern = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "pattern"));
        this.getParentElement((EObject)object).appendChild(pattern);
        pattern.setAttribute("patternUnits", "objectBoundingBox");
        if (object.getBounds() != null) {
            Bounds bounds = object.getBounds();
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__X)) {
                pattern.setAttribute("x", String.valueOf(this.convertDoubleToString(bounds.getX())) + "%");
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__Y)) {
                pattern.setAttribute("y", String.valueOf(this.convertDoubleToString(bounds.getY())) + "%");
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__WIDTH)) {
                pattern.setAttribute("width", String.valueOf(this.convertDoubleToString(bounds.getWidth())) + "%");
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__HEIGHT)) {
                pattern.setAttribute("height", String.valueOf(this.convertDoubleToString(bounds.getHeight())) + "%");
            }
        }
        if (object.getTransforms().size() > 0) {
            String transforms = "";
            for (Transform transform : object.getTransforms()) {
                transforms = String.valueOf(transforms) + (transforms.length() > 0 ? " " : "");
                transforms = String.valueOf(transforms) + (String)this.doSwitch((EObject)transform);
            }
            pattern.setAttribute("patternTransform", transforms);
        }
        return super.casePattern(object);
    }

    public Object casePolygon(Polygon object) {
        Element polygon = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "polygon"));
        this.getParentElement((EObject)object).appendChild(polygon);
        if (!object.getPoints().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Point point : object.getPoints()) {
                sb.append(sb.length() > 0 ? " " : "");
                sb.append(this.convertDoubleToString(point.getX()));
                sb.append(",");
                sb.append(this.convertDoubleToString(point.getY()));
            }
            polygon.setAttribute("points", sb.toString());
        }
        return super.casePolygon(object);
    }

    public Object casePolyline(Polyline object) {
        Element polyline = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "polyline"));
        this.getParentElement((EObject)object).appendChild(polyline);
        if (!object.getPoints().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Point point : object.getPoints()) {
                sb.append(sb.length() > 0 ? " " : "");
                sb.append(this.convertDoubleToString(point.getX()));
                sb.append(",");
                sb.append(this.convertDoubleToString(point.getY()));
            }
            polyline.setAttribute("points", sb.toString());
        }
        return super.casePolyline(object);
    }

    public Object caseQuadraticCurveTo(QuadraticCurveTo object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append(object.isRelative() ? "q" : "Q");
        if (object.getControl() != null) {
            Point end = object.getControl();
            sb.append(String.valueOf(this.convertDoubleToString(end.getX())) + "," + this.convertDoubleToString(end.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        sb.append(" ");
        if (object.getPoint() != null) {
            Point point = object.getPoint();
            sb.append(String.valueOf(this.convertDoubleToString(point.getX())) + "," + this.convertDoubleToString(point.getY()));
        } else {
            sb.append("0.0,0.0");
        }
        return super.caseQuadraticCurveTo(object);
    }

    public Object caseRadialGradient(RadialGradient object) {
        Element gradient = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "radialGradient"));
        this.getParentElement((EObject)object).appendChild(gradient);
        gradient.setAttribute("gradientUnits", "objectBoundingBox");
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.RADIAL_GRADIENT__RADIUS)) {
            gradient.setAttribute("r", String.valueOf(this.convertDoubleToString(object.getRadius())) + "%");
        }
        if (object.getCenter() != null) {
            Point center = object.getCenter();
            if (center.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                gradient.setAttribute("cx", String.valueOf(this.convertDoubleToString(center.getX())) + "%");
            }
            if (center.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                gradient.setAttribute("cy", String.valueOf(this.convertDoubleToString(center.getY())) + "%");
            }
        }
        if (object.getFocus() != null) {
            Point focus = object.getFocus();
            if (focus.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__X)) {
                gradient.setAttribute("fx", String.valueOf(this.convertDoubleToString(focus.getX())) + "%");
            }
            if (focus.eIsSet((EStructuralFeature)DCPackage.Literals.POINT__Y)) {
                gradient.setAttribute("fy", String.valueOf(this.convertDoubleToString(focus.getY())) + "%");
            }
        }
        return super.caseRadialGradient(object);
    }

    public Object caseRectangle(Rectangle object) {
        Element rect = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "rect"));
        this.getParentElement((EObject)object).appendChild(rect);
        if (object.getBounds() != null) {
            Bounds bounds = object.getBounds();
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__X)) {
                rect.setAttribute("x", this.convertDoubleToString(bounds.getX()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__Y)) {
                rect.setAttribute("y", this.convertDoubleToString(bounds.getY()));
            }
            rect.setAttribute("width", this.convertDoubleToString(bounds.getWidth()));
            rect.setAttribute("height", this.convertDoubleToString(bounds.getHeight()));
        } else {
            rect.setAttribute("width", "0.0");
            rect.setAttribute("height", "0.0");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.RECTANGLE__CORNER_RADIUS)) {
            rect.setAttribute("rx", this.convertDoubleToString(object.getCornerRadius()));
            rect.setAttribute("ry", this.convertDoubleToString(object.getCornerRadius()));
        }
        return super.caseRectangle(object);
    }

    public Object caseRootCanvas(RootCanvas object) {
        Element svg = this.map((EObject)object, this.svgDocument.getDocumentElement());
        svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        svg.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        svg.setAttribute("onload", "validate()");
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.ROOT_CANVAS__BACKGROUND_COLOR)) {
            String background = this.convertColorToString(object.getBackgroundColor());
            svg.setAttribute(SVG_BACKGROUND_COLOR_ATTRIBUTE, background);
        }
        for (StyleSheet styleSheet : object.getExternalStyleSheets()) {
            String target = "xml-stylesheet";
            String data = "type=\"text/css\" href=\"" + styleSheet.eResource().getURI() + ".css\" ?>";
            ProcessingInstruction pi = this.svgDocument.createProcessingInstruction(target, data);
            this.svgDocument.insertBefore(pi, this.svgDocument.getDocumentElement());
        }
        try {
            URL url = DDEditorPlugin.getPlugin().getBundle().getEntry("/scripts/Layout.js");
            url = FileLocator.toFileURL((URL)url);
            Element script = this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "script");
            script.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", url.toString());
            svg.appendChild(script);
        }
        catch (IOException e) {
            DDEditorPlugin.getPlugin().log(e);
        }
        if (object.getDefinitions() != null) {
            this.doSwitch((EObject)object.getDefinitions());
        }
        return super.caseRootCanvas(object);
    }

    public Object caseRotate(Rotate object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append("rotate(");
        sb.append(this.convertDoubleToString(object.getAngle()));
        if (object.getCenter() != null) {
            Point center = object.getCenter();
            sb.append(", ");
            sb.append(this.convertDoubleToString(center.getX()));
            sb.append(", ");
            sb.append(this.convertDoubleToString(center.getY()));
        }
        sb.append(")");
        return super.caseRotate(object);
    }

    public Object caseScale(Scale object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append("scale(");
        sb.append(this.convertDoubleToString(object.getFactorX()));
        sb.append(", ");
        sb.append(this.convertDoubleToString(object.getFactorY()));
        sb.append(")");
        return super.caseScale(object);
    }

    public Object caseSkew(Skew object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.SKEW__ANGLE_X)) {
            sb.append("skewX(");
            sb.append(this.convertDoubleToString(object.getAngleX()));
            sb.append(")");
        }
        sb.append(sb.length() > 0 ? " " : "");
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.SKEW__ANGLE_Y)) {
            sb.append("skewY(");
            sb.append(this.convertDoubleToString(object.getAngleY()));
            sb.append(")");
        }
        return super.caseSkew(object);
    }

    public Object caseStyle(Style object) {
        CharSequence value;
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__FILL)) {
            value = object.getFill() == null ? "none" : (String)this.doSwitch((EObject)object.getFill());
            sb.append("fill: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__FILL_OPACITY)) {
            value = this.convertDoubleToString(object.getFillOpacity());
            sb.append("fill-opacity: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__STROKE)) {
            value = object.getStroke() == null ? "none" : (String)this.doSwitch((EObject)object.getStroke());
            sb.append("stroke: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__STROKE_OPACITY)) {
            value = this.convertDoubleToString(object.getStrokeOpacity());
            sb.append("stroke-opacity: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__STROKE_WIDTH)) {
            value = this.convertDoubleToString(object.getStrokeWidth());
            sb.append("stroke-width: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__STROKE_DASH_LENGTH)) {
            value = new StringBuffer();
            Iterator iterator = object.getStrokeDashLengths().iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                ((StringBuffer)value).append(((StringBuffer)value).length() > 0 ? ", " : "");
                ((StringBuffer)value).append(this.convertDoubleToString(d));
            }
            sb.append("stroke-dasharray: " + ((StringBuffer)value).toString() + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_NAME)) {
            value = "\"" + object.getFontName() + "\"";
            sb.append("font-family: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_SIZE)) {
            value = this.convertDoubleToString(object.getFontSize());
            sb.append("font-size: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_BOLD)) {
            value = object.isFontBold() ? "bold" : "normal";
            sb.append("font-weight: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_ITALIC)) {
            value = object.isFontItalic() ? "italic" : "normal";
            sb.append("font-style: " + (String)value + "; ");
        }
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_DECORATION)) {
            FontDecoration fd = object.getFontDecoration();
            String value2 = "none";
            if (fd != null) {
                if (fd.equals((Object)FontDecoration.UNDERLINE)) {
                    value2 = "underline";
                } else if (fd.equals((Object)FontDecoration.OVERLINE)) {
                    value2 = "overline";
                } else if (fd.equals((Object)FontDecoration.LINE_THROUGH)) {
                    value2 = "line-through";
                }
            }
            sb.append("text-decoration: " + value2 + "; ");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return super.caseStyle(object);
    }

    public Object caseStyleRule(StyleRule object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        if (!object.getSelectors().isEmpty() && object.getStyle() != null) {
            for (StyleSelector selector : object.getSelectors()) {
                sb.append(sb.length() > 0 ? ", " : "");
                sb.append((String)this.doSwitch((EObject)selector));
            }
            if (object.getStyle() != null) {
                String style = (String)this.doSwitch((EObject)object.getStyle());
                sb.append(" { " + style + " }");
            }
        }
        return super.caseStyleRule(object);
    }

    public Object caseStyleSelector(StyleSelector object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        if (object.eIsSet((EStructuralFeature)DGPackage.Literals.STYLE_SELECTOR__KIND)) {
            switch (object.getKind()) {
                case CANVAS: {
                    sb.append("svg");
                    break;
                }
                case CIRCLE: {
                    sb.append("circle");
                    break;
                }
                case CLIP_PATH: {
                    sb.append("clipPath");
                    break;
                }
                case ELLIPSE: {
                    sb.append("ellipse");
                    break;
                }
                case GROUP: {
                    sb.append("g");
                    break;
                }
                case IMAGE: {
                    sb.append("image");
                    break;
                }
                case LINE: {
                    sb.append("line");
                    break;
                }
                case MARKER: {
                    sb.append("marker");
                    break;
                }
                case PATH: {
                    sb.append("path");
                    break;
                }
                case POLYGON: {
                    sb.append("polygon");
                    break;
                }
                case POLYLINE: {
                    sb.append("polyline");
                    break;
                }
                case RECTANGLE: {
                    sb.append("rect");
                    break;
                }
                case TEXT: {
                    sb.append("text");
                    break;
                }
                case USE: {
                    sb.append("use");
                }
            }
        }
        for (String class_ : object.getClasses()) {
            sb.append("." + class_);
        }
        if (sb.length() == 0) {
            sb.append("*");
        }
        return super.caseStyleSelector(object);
    }

    public Object caseStyleSheet(StyleSheet object) {
        Element styleSheet = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "style"));
        this.getParentElement((EObject)object).appendChild(styleSheet);
        StringBuffer sb = new StringBuffer();
        for (StyleRule rule : object.getRules()) {
            sb.append("\n\t\t\t" + (String)this.doSwitch((EObject)rule));
        }
        styleSheet.setAttribute("type", "text/css");
        styleSheet.appendChild(this.svgDocument.createCDATASection(sb.toString()));
        return super.caseStyleSheet(object);
    }

    public Object caseText(Text object) {
        Element text = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "text"));
        this.getParentElement((EObject)object).appendChild(text);
        if (object.getData() != null) {
            text.setTextContent(object.getData().replaceAll("\n", "\\\\n"));
        }
        if (object.getBounds() != null) {
            Bounds bounds = object.getBounds();
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__X)) {
                text.setAttribute("x", this.convertDoubleToString(bounds.getX()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__Y)) {
                text.setAttribute("y", this.convertDoubleToString(bounds.getY()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__WIDTH)) {
                text.setAttribute("width", this.convertDoubleToString(bounds.getWidth()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__HEIGHT)) {
                text.setAttribute("height", this.convertDoubleToString(bounds.getHeight()));
            }
        }
        if (object.getAnchor() != null) {
            TextAnchor ta = object.getAnchor();
            String value = null;
            if (ta.equals((Object)TextAnchor.START)) {
                value = "start";
            } else if (ta.equals((Object)TextAnchor.MIDDLE)) {
                value = "middle";
            } else if (ta.equals((Object)TextAnchor.END)) {
                value = "end";
            }
            text.setAttribute("text-anchor", value);
        }
        return super.caseText(object);
    }

    public Object caseTransform(Transform object) {
        return super.caseTransform(object);
    }

    public Object caseTranslate(Translate object) {
        StringBuffer sb = this.map((EObject)object, new StringBuffer());
        sb.append("translate(");
        sb.append(this.convertDoubleToString(object.getDeltaX()));
        sb.append(", ");
        sb.append(this.convertDoubleToString(object.getDeltaY()));
        sb.append(")");
        return super.caseTranslate(object);
    }

    public Object caseUse(Use object) {
        Element use = this.map((EObject)object, this.svgDocument.createElementNS("http://www.w3.org/2000/svg", "use"));
        this.getParentElement((EObject)object).appendChild(use);
        if (object.getReferencedElement() != null) {
            use.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", this.convertReferenceToURI((Definition)object.getReferencedElement()));
        }
        if (object.getBounds() != null) {
            Bounds bounds = object.getBounds();
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__X)) {
                use.setAttribute("x", this.convertDoubleToString(bounds.getX()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__Y)) {
                use.setAttribute("y", this.convertDoubleToString(bounds.getY()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__WIDTH)) {
                use.setAttribute("width", this.convertDoubleToString(bounds.getWidth()));
            }
            if (bounds.eIsSet((EStructuralFeature)DCPackage.Literals.BOUNDS__HEIGHT)) {
                use.setAttribute("height", this.convertDoubleToString(bounds.getHeight()));
            }
        }
        return super.caseUse(object);
    }
}

