/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.presentation;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.dd.presentation.DDEditor;
import org.eclipse.papyrus.dd.presentation.DDEditorPlugin;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class DDEditorPage
extends FormPage {
    private Viewer viewer;

    public DDEditorPage(DDEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    public DDEditor getDDEditor() {
        return (DDEditor)this.getEditor();
    }

    protected static String getString(String key) {
        return DDEditorPlugin.INSTANCE.getString(key);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        form.setText(this.getTitle());
        Composite body = form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.viewer = this.createViewer(body);
        this.setupActions(form.getToolBarManager());
        form.updateToolBar();
    }

    protected abstract Viewer createViewer(Composite var1);

    public Viewer getViewer() {
        return this.viewer;
    }

    public void setActive(boolean active) {
        if (active) {
            this.getDDEditor().setCurrentViewer(this.viewer);
            this.refresh();
        }
        super.setActive(active);
    }

    public void refresh() {
    }

    public void setupActions(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("Page"));
        manager.add((IContributionItem)new Separator("Common"));
        Action action = new Action("Help"){

            public void run() {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(DDEditorPage.this.getPageHelpId());
            }
        };
        action.setToolTipText("Show help");
        action.setImageDescriptor(DDEditorPlugin.getImageDescriptor("Help"));
        manager.appendToGroup("Common", (IAction)action);
    }

    protected String getPageHelpId() {
        return "";
    }
}

