/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.presentation;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.dd.presentation.DDEditor;
import org.eclipse.papyrus.dd.presentation.DDEditorPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class DDModelPage
extends DDEditorPage {
    public static final String ID = DDModelPage.class.getName();
    protected TreeViewer viewer;

    public DDModelPage(DDEditor editor) {
        super(editor, ID, DDModelPage.getString("DDModelPage.title"));
    }

    @Override
    protected Viewer createViewer(Composite formBody) {
        EditingDomain editingDomain = this.getDDEditor().getEditingDomain();
        AdapterFactory adapterFactory = this.getDDEditor().getAdapterFactory();
        Tree tree = new Tree(formBody, 2);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory));
        this.viewer.setInput((Object)editingDomain.getResourceSet());
        this.viewer.setSelection((ISelection)new StructuredSelection(editingDomain.getResourceSet().getResources().get(0)), true);
        new AdapterFactoryTreeEditor(tree, adapterFactory);
        this.getDDEditor().createContextMenuFor((StructuredViewer)this.viewer);
        return this.viewer;
    }

    public boolean selectReveal(Object object) {
        if (object instanceof StructuredSelection) {
            this.viewer.setSelection((ISelection)((StructuredSelection)object), true);
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
        return true;
    }
}

