/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagramtemplate.editor;

import com.swtdesigner.ResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.diagramtemplate.AbstractSelection;
import org.eclipse.papyrus.diagramtemplate.DiagramDefinition;
import org.eclipse.papyrus.diagramtemplate.DiagramTemplateFactory;
import org.eclipse.papyrus.diagramtemplate.DiagramTemplatePackage;
import org.eclipse.papyrus.diagramtemplate.Selection;
import org.eclipse.papyrus.diagramtemplate.SelectionKind;
import org.eclipse.papyrus.diagramtemplate.SelectionRef;
import org.eclipse.papyrus.diagramtemplate.Template;
import org.eclipse.papyrus.diagramtemplate.editor.DiagramTemplateEditorPlugin;
import org.eclipse.papyrus.diagramtemplate.editor.provider.DiagramDefinitionContentProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.DiagramDefinitionLabelProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.DiagramKindContentProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.ElementsAvailableContentProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.ForContentProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.ForLabelProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.TypesAvailableFromEReferenceContentProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.TypesContentProvider;
import org.eclipse.papyrus.diagramtemplate.editor.provider.WhatContentProvider;
import org.eclipse.papyrus.diagramtemplate.launcher.DiagramTemplateLauncher;
import org.eclipse.papyrus.diagramtemplate.provider.DiagramTemplateItemProviderAdapterFactory;
import org.eclipse.papyrus.diagramtemplate.utils.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryRegistry;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.eclipse.uml2.uml.resource.UMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramTemplateEditor
extends EditorPart {
    private static final String DEFAULT_NAME = Messages.DiagramTemplateEditor_0;
    private static final String DEFAULT_PREFIX = Messages.DiagramTemplateEditor_1;
    private Text targetModelPathText;
    private Table diagramDefinitionTable;
    private TableViewer diagramDefinitionTableViewer;
    private Text nameText;
    private Text prefixText;
    private Text rootText;
    private Text descriptionText;
    private Table diagramTable;
    private CheckboxTableViewer diagramCheckboxTableViewer;
    private Table whatTable;
    private TableViewer whatTableViewer;
    private Tree forTree;
    private TreeViewer forTreeViewer;
    private Button addDiagramDefinitionButton;
    private Button selectRootButton;
    private Button specificForButton;
    private Button specificWhatButton;
    private Button loadModelButton;
    private Button executeButton;
    List<String> diagramCategories = new ArrayList<String>();
    private IFile modelFile;
    private ResourceSet targetModelResourceSet;
    private Resource targetModelResource = null;
    protected ComposedAdapterFactory adapterFactory;
    protected AdapterFactoryEditingDomain editingDomain;
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    private DiagramDefinition currentDiagramDefinition;
    private Resource templateResource;
    private Template template;
    private DiagramTemplateFactory diagramtemplateFactory;

    public DiagramTemplateEditor() {
        this.initializeEditingDomain();
        this.initializeDiagramCategories();
        DiagramTemplatePackage diagramtemplatePackage = DiagramTemplatePackage.eINSTANCE;
        this.diagramtemplateFactory = diagramtemplatePackage.getDiagramTemplateFactory();
    }

    private static String getString(String key, Object s1) {
        return DiagramTemplateEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    protected boolean createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        try {
            this.templateResource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            this.templateResource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(this.templateResource, exception);
        if (diagnostic.getSeverity() != 0) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DiagramTemplateEditor_2, (String)Messages.DiagramTemplateEditor_3);
            return false;
        }
        if (this.templateResource.getContents().isEmpty()) {
            this.template = this.diagramtemplateFactory.createTemplate();
            this.templateResource.getContents().add((Object)this.template);
        } else {
            this.template = (Template)this.templateResource.getContents().get(0);
            if (this.template.getTargetRoot() != null) {
                Resource res = this.template.getTargetRoot().eResource();
                if (res != null) {
                    this.targetModelResource = res;
                } else {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DiagramTemplateEditor_4, (String)Messages.DiagramTemplateEditor_5);
                }
            }
        }
        return true;
    }

    protected Resource loadModel(ResourceSet resourceSet, IFile file) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", UMLResource.Factory.INSTANCE);
        return resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
    }

    protected void updateRootText() {
        if (this.currentDiagramDefinition.getFromRoot() instanceof NamedElement) {
            this.rootText.setText(((NamedElement)this.currentDiagramDefinition.getFromRoot()).getQualifiedName());
        } else {
            this.rootText.setText(this.currentDiagramDefinition.getFromRoot().toString());
        }
    }

    protected void updateUI() {
        this.diagramDefinitionTableViewer.refresh();
        this.forTreeViewer.setInput((Object)this.currentDiagramDefinition.getSelection());
        this.forTreeViewer.refresh();
        this.whatTableViewer.refresh();
        this.diagramCheckboxTableViewer.refresh();
        this.nameText.setText(this.currentDiagramDefinition.getName());
        this.descriptionText.setText(this.currentDiagramDefinition.getDescription());
        this.prefixText.setText(this.currentDiagramDefinition.getPrefix());
        if (this.currentDiagramDefinition.getFromRoot() != null) {
            this.updateRootText();
        } else {
            this.rootText.setText("");
        }
    }

    protected void initializeDiagramCategories() {
        for (DiagramCategoryDescriptor diagramCategoryDescriptor : DiagramCategoryRegistry.getInstance().getDiagramCategories()) {
            this.diagramCategories.add(diagramCategoryDescriptor.getLabel());
        }
    }

    protected boolean containsElement(EObject object, List<?> list) {
        if (list != null) {
            for (Object selection : list) {
                if (((AbstractSelection)selection).getElement() != object) continue;
                return true;
            }
        }
        return false;
    }

    protected void clearTemplate() {
        TreeIterator it = this.template.eAllContents();
        while (it.hasNext()) {
            RemoveCommand command;
            EObject eObject = (EObject)it.next();
            if (eObject instanceof DiagramDefinition) {
                ((DiagramDefinition)eObject).setFromRoot(null);
                continue;
            }
            if (eObject instanceof Selection) {
                if (((AbstractSelection)eObject).getKind() == SelectionKind.FOR_ALL) continue;
                command = new RemoveCommand((EditingDomain)this.editingDomain, ((Selection)eObject).eContainer(), ((Selection)eObject).eContainer().eClass().getEStructuralFeature("selection"), (Object)eObject);
                this.editingDomain.getCommandStack().execute((Command)command);
                it = this.template.eAllContents();
                continue;
            }
            if (!(eObject instanceof SelectionRef) || ((AbstractSelection)eObject).getKind() == SelectionKind.FOR_ALL) continue;
            command = new RemoveCommand((EditingDomain)this.editingDomain, ((SelectionRef)eObject).eContainer(), ((SelectionRef)eObject).eContainer().eClass().getEStructuralFeature("selectionRef"), (Object)eObject);
            this.editingDomain.getCommandStack().execute((Command)command);
            it = this.template.eAllContents();
        }
        SetCommand command = new SetCommand((EditingDomain)this.editingDomain, (EObject)this.template, this.template.eClass().getEStructuralFeature("targetRoot"), null);
        this.editingDomain.getCommandStack().execute((Command)command);
        this.modelFile = null;
        this.targetModelPathText.setText("");
        this.targetModelResourceSet = null;
        this.targetModelResource = null;
        this.loadModelButton.setEnabled(true);
        this.selectRootButton.setEnabled(false);
        this.executeButton.setEnabled(false);
        this.specificForButton.setEnabled(false);
        this.updateUI();
    }

    protected void createNewDiagramDefinition() {
        this.currentDiagramDefinition = this.diagramtemplateFactory.createDiagramDefinition();
        this.currentDiagramDefinition.setName(DEFAULT_NAME);
        this.currentDiagramDefinition.setDescription("");
        this.currentDiagramDefinition.setPrefix(DEFAULT_PREFIX);
        if (this.targetModelResource != null) {
            this.currentDiagramDefinition.setFromRoot((EObject)this.targetModelResource.getContents().get(0));
        }
        this.updateUI();
        this.addDiagramDefinitionButton.setEnabled(true);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.papyrus.diagramtemplate.editor", 0, DiagramTemplateEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.papyrus.diagramtemplate.editor", 0, DiagramTemplateEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new DiagramTemplateItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new UMLItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                DiagramTemplateEditor.this.updateUI();
                DiagramTemplateEditor.this.firePropertyChange(257);
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void doSave(IProgressMonitor monitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : DiagramTemplateEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !DiagramTemplateEditor.this.isPersisted(resource) || DiagramTemplateEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        resource.save(saveOptions);
                    }
                    catch (Exception exception) {
                        DiagramTemplateEditor.this.resourceToDiagnosticMap.put(resource, DiagramTemplateEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            DiagramTemplateEditorPlugin.INSTANCE.log(exception);
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.setPartName(input.getName());
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void createloadPart(Composite parent) {
        Composite loadComposite = new Composite(parent, 0);
        loadComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        loadComposite.setLayout((Layout)new GridLayout(5, false));
        this.executeButton = new Button(loadComposite, 0);
        this.executeButton.setText(Messages.DiagramTemplateEditor_15);
        this.executeButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/execute.gif"));
        this.executeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (DiagramTemplateEditor.this.targetModelResource != null) {
                    DiagramTemplateLauncher launcher = DiagramTemplateLauncher.getInstance();
                    launcher.execute(DiagramTemplateEditor.this.template);
                } else {
                    MessageDialog.openInformation((Shell)DiagramTemplateEditor.this.getSite().getShell(), (String)Messages.DiagramTemplateEditor_18, (String)Messages.DiagramTemplateEditor_19);
                }
            }
        });
        this.executeButton.setEnabled(false);
        Label loadLabel = new Label(loadComposite, 0);
        loadLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        loadLabel.setText(Messages.DiagramTemplateEditor_20);
        this.targetModelPathText = new Text(loadComposite, 2048);
        this.targetModelPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.targetModelPathText.setEditable(false);
        this.loadModelButton = new Button(loadComposite, 0);
        this.loadModelButton.setText(Messages.DiagramTemplateEditor_21);
        this.loadModelButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(DiagramTemplateEditor.this.getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IContainer) {
                            return true;
                        }
                        return ((IFile)element).getFileExtension().compareToIgnoreCase("uml") == 0;
                    }
                });
                dialog.setAllowMultiple(false);
                dialog.setTitle(Messages.DiagramTemplateEditor_23);
                dialog.setMessage(Messages.DiagramTemplateEditor_24);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.open();
                Object result = dialog.getFirstResult();
                if (result instanceof IFile) {
                    DiagramTemplateEditor.this.modelFile = (IFile)dialog.getFirstResult();
                    DiagramTemplateEditor.this.targetModelResourceSet = (ResourceSet)new ResourceSetImpl();
                    DiagramTemplateEditor.this.targetModelResource = DiagramTemplateEditor.this.loadModel(DiagramTemplateEditor.this.targetModelResourceSet, DiagramTemplateEditor.this.modelFile);
                    DiagramTemplateEditor.this.targetModelPathText.setText(DiagramTemplateEditor.this.targetModelResource.getURI().toString());
                    SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.template, DiagramTemplateEditor.this.template.eClass().getEStructuralFeature("targetRoot"), DiagramTemplateEditor.this.targetModelResource.getContents().get(0));
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    for (DiagramDefinition diagramDefinition : DiagramTemplateEditor.this.template.getDiagramDefinitions()) {
                        diagramDefinition.setFromRoot((EObject)DiagramTemplateEditor.this.targetModelResource.getContents().get(0));
                    }
                    DiagramTemplateEditor.this.selectRootButton.setEnabled(true);
                    DiagramTemplateEditor.this.loadModelButton.setEnabled(false);
                    DiagramTemplateEditor.this.specificForButton.setEnabled(true);
                    DiagramTemplateEditor.this.executeButton.setEnabled(true);
                    DiagramTemplateEditor.this.updateUI();
                }
            }
        });
        Button clearButton = new Button(loadComposite, 0);
        clearButton.setText(Messages.DiagramTemplateEditor_26);
        clearButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (MessageDialog.openConfirm((Shell)DiagramTemplateEditor.this.getSite().getShell(), (String)Messages.DiagramTemplateEditor_27, (String)Messages.DiagramTemplateEditor_28)) {
                    DiagramTemplateEditor.this.clearTemplate();
                }
            }
        });
    }

    private void createDiagramDefinitionPart(Composite parent) {
        Composite diagramDefinitionPartComposite = new Composite(parent, 0);
        diagramDefinitionPartComposite.setLayout((Layout)new GridLayout(1, false));
        Composite diagramDefinitionButtonsComposite = new Composite(diagramDefinitionPartComposite, 0);
        GridLayout gl_diagramDefinitionButtonsComposite = new GridLayout(6, false);
        gl_diagramDefinitionButtonsComposite.horizontalSpacing = 0;
        gl_diagramDefinitionButtonsComposite.verticalSpacing = 1;
        gl_diagramDefinitionButtonsComposite.marginWidth = 0;
        gl_diagramDefinitionButtonsComposite.marginHeight = 0;
        diagramDefinitionButtonsComposite.setLayout((Layout)gl_diagramDefinitionButtonsComposite);
        diagramDefinitionButtonsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Button newDiagramDefinitionButton = new Button(diagramDefinitionButtonsComposite, 0);
        newDiagramDefinitionButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/new.gif"));
        newDiagramDefinitionButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                DiagramTemplateEditor.this.createNewDiagramDefinition();
                DiagramTemplateEditor.this.addDiagramDefinitionButton.setEnabled(true);
            }
        });
        this.addDiagramDefinitionButton = new Button(diagramDefinitionButtonsComposite, 0);
        this.addDiagramDefinitionButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/add.gif"));
        this.addDiagramDefinitionButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (DiagramTemplateEditor.this.currentDiagramDefinition.getDiagramKind() != null) {
                    if (DiagramTemplateEditor.this.template != null) {
                        AddCommand command = new AddCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.template, DiagramTemplateEditor.this.template.eClass().getEStructuralFeature("diagramDefinitions"), (Object)DiagramTemplateEditor.this.currentDiagramDefinition);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    }
                    DiagramTemplateEditor.this.createNewDiagramDefinition();
                } else {
                    MessageDialog.openWarning((Shell)DiagramTemplateEditor.this.getSite().getShell(), (String)Messages.DiagramTemplateEditor_34, (String)Messages.DiagramTemplateEditor_35);
                }
            }
        });
        Button removeDiagramDefinitionButton = new Button(diagramDefinitionButtonsComposite, 0);
        removeDiagramDefinitionButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/delete.gif"));
        removeDiagramDefinitionButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.diagramDefinitionTableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object object : (IStructuredSelection)selection) {
                        RemoveCommand command = new RemoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.template, DiagramTemplateEditor.this.template.eClass().getEStructuralFeature("diagramDefinitions"), object);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    }
                    DiagramTemplateEditor.this.diagramDefinitionTableViewer.refresh();
                    DiagramTemplateEditor.this.createNewDiagramDefinition();
                }
            }
        });
        Button moveUpDiagramDefinitionButton = new Button(diagramDefinitionButtonsComposite, 0);
        moveUpDiagramDefinitionButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/up.gif"));
        moveUpDiagramDefinitionButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.diagramDefinitionTableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    DiagramDefinition diagramDefinition = (DiagramDefinition)((IStructuredSelection)selection).getFirstElement();
                    MoveCommand command = new MoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.template, DiagramTemplateEditor.this.template.eClass().getEStructuralFeature("diagramDefinitions"), (Object)diagramDefinition, DiagramTemplateEditor.this.template.getDiagramDefinitions().indexOf((Object)diagramDefinition) - 1);
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    DiagramTemplateEditor.this.diagramDefinitionTableViewer.refresh();
                }
            }
        });
        Button moveDownDiagramDefinitionButton = new Button(diagramDefinitionButtonsComposite, 0);
        moveDownDiagramDefinitionButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/down.gif"));
        moveDownDiagramDefinitionButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.diagramDefinitionTableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    DiagramDefinition diagramDefinition = (DiagramDefinition)((IStructuredSelection)selection).getFirstElement();
                    MoveCommand command = new MoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.template, DiagramTemplateEditor.this.template.eClass().getEStructuralFeature("diagramDefinitions"), (Object)diagramDefinition, DiagramTemplateEditor.this.template.getDiagramDefinitions().indexOf((Object)diagramDefinition) + 1);
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    DiagramTemplateEditor.this.diagramDefinitionTableViewer.refresh();
                }
            }
        });
        Button copyDiagramDefinitionButton = new Button(diagramDefinitionButtonsComposite, 0);
        copyDiagramDefinitionButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/copy.gif"));
        copyDiagramDefinitionButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.diagramDefinitionTableViewer.getSelection();
                if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                    DiagramDefinition diagramDefinition = (DiagramDefinition)((IStructuredSelection)selection).getFirstElement();
                    EcoreUtil.Copier copier = new EcoreUtil.Copier();
                    DiagramDefinition diagramDefinitionCopy = (DiagramDefinition)copier.copy((EObject)diagramDefinition);
                    copier.copyReferences();
                    diagramDefinitionCopy.setName(String.valueOf(Messages.DiagramTemplateEditor_47) + diagramDefinitionCopy.getName());
                    if (DiagramTemplateEditor.this.template != null) {
                        AddCommand command = new AddCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.template, DiagramTemplateEditor.this.template.eClass().getEStructuralFeature("diagramDefinitions"), (Object)diagramDefinitionCopy);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    }
                    DiagramTemplateEditor.this.createNewDiagramDefinition();
                }
            }
        });
        this.diagramDefinitionTableViewer = new TableViewer(diagramDefinitionPartComposite, 67584);
        this.diagramDefinitionTable = this.diagramDefinitionTableViewer.getTable();
        this.diagramDefinitionTable.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.diagramDefinitionTableViewer.setContentProvider((IContentProvider)new DiagramDefinitionContentProvider());
        this.diagramDefinitionTableViewer.setLabelProvider((IBaseLabelProvider)new DiagramDefinitionLabelProvider());
        this.diagramDefinitionTableViewer.setInput((Object)this.template.getDiagramDefinitions());
        this.diagramDefinitionTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection && !event.getSelection().isEmpty()) {
                    DiagramTemplateEditor.this.currentDiagramDefinition = (DiagramDefinition)((IStructuredSelection)event.getSelection()).getFirstElement();
                    DiagramTemplateEditor.this.updateUI();
                    DiagramTemplateEditor.this.addDiagramDefinitionButton.setEnabled(false);
                }
            }
        });
    }

    private void createDiagramInformationPart(Composite parent) {
        Composite diagramInformationComposite = new Composite(parent, 0);
        diagramInformationComposite.setLayout((Layout)new GridLayout(5, false));
        Label nameLabel = new Label(diagramInformationComposite, 0);
        nameLabel.setText(Messages.DiagramTemplateEditor_49);
        this.nameText = new Text(diagramInformationComposite, 2048);
        this.nameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.currentDiagramDefinition, DiagramTemplateEditor.this.currentDiagramDefinition.eClass().getEStructuralFeature("name"), (Object)DiagramTemplateEditor.this.nameText.getText());
                DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
            }
        });
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label descriptionLabel = new Label(diagramInformationComposite, 0);
        descriptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 3));
        descriptionLabel.setText(Messages.DiagramTemplateEditor_51);
        this.descriptionText = new Text(diagramInformationComposite, 2050);
        this.descriptionText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.currentDiagramDefinition, DiagramTemplateEditor.this.currentDiagramDefinition.eClass().getEStructuralFeature("description"), (Object)DiagramTemplateEditor.this.descriptionText.getText());
                DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
            }
        });
        this.descriptionText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        Label prefixLabel = new Label(diagramInformationComposite, 0);
        prefixLabel.setText(Messages.DiagramTemplateEditor_53);
        this.prefixText = new Text(diagramInformationComposite, 2048);
        this.prefixText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.currentDiagramDefinition, DiagramTemplateEditor.this.currentDiagramDefinition.eClass().getEStructuralFeature("prefix"), (Object)DiagramTemplateEditor.this.prefixText.getText());
                DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
            }
        });
        this.prefixText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label rootLabel = new Label(diagramInformationComposite, 0);
        rootLabel.setText(Messages.DiagramTemplateEditor_55);
        this.rootText = new Text(diagramInformationComposite, 2048);
        this.rootText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.rootText.setEditable(false);
        this.selectRootButton = new Button(diagramInformationComposite, 0);
        this.selectRootButton.setText(Messages.DiagramTemplateEditor_56);
        this.selectRootButton.setEnabled(false);
        this.selectRootButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(DiagramTemplateEditor.this.getSite().getShell(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)DiagramTemplateEditor.this.adapterFactory), (ITreeContentProvider)new AdapterFactoryContentProvider((AdapterFactory)DiagramTemplateEditor.this.adapterFactory));
                dlg.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof EObject;
                    }
                });
                dlg.setAllowMultiple(false);
                dlg.setTitle(Messages.DiagramTemplateEditor_57);
                dlg.setMessage(Messages.DiagramTemplateEditor_58);
                dlg.setInput((Object)DiagramTemplateEditor.this.targetModelResource);
                dlg.open();
                Object result = dlg.getFirstResult();
                if (result instanceof EObject) {
                    SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.currentDiagramDefinition, DiagramTemplateEditor.this.currentDiagramDefinition.eClass().getEStructuralFeature("fromRoot"), result);
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    DiagramTemplateEditor.this.updateRootText();
                }
            }
        });
        Label diagramLabel = new Label(diagramInformationComposite, 0);
        diagramLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 5, 1));
        diagramLabel.setText(Messages.DiagramTemplateEditor_60);
        this.diagramCheckboxTableViewer = CheckboxTableViewer.newCheckList((Composite)diagramInformationComposite, (int)67584);
        this.diagramTable = this.diagramCheckboxTableViewer.getTable();
        this.diagramTable.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.diagramCheckboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof CreationCommandDescriptor) {
                    SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.currentDiagramDefinition, DiagramTemplateEditor.this.currentDiagramDefinition.eClass().getEStructuralFeature("diagramKind"), (Object)((CreationCommandDescriptor)element).getCommandId());
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                }
                DiagramTemplateEditor.this.diagramCheckboxTableViewer.setCheckedElements(new Object[0]);
                DiagramTemplateEditor.this.diagramCheckboxTableViewer.setChecked(element, true);
            }
        });
        this.diagramCheckboxTableViewer.setContentProvider((IContentProvider)new DiagramKindContentProvider());
        this.diagramCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new DiagramKindLabelProvider());
        this.diagramCheckboxTableViewer.setInput(this.diagramCategories);
        this.diagramCheckboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (DiagramTemplateEditor.this.currentDiagramDefinition != null && element instanceof CreationCommandDescriptor && DiagramTemplateEditor.this.currentDiagramDefinition.getDiagramKind() != null) {
                    return ((CreationCommandDescriptor)element).getCommandId().equals(DiagramTemplateEditor.this.currentDiagramDefinition.getDiagramKind());
                }
                return false;
            }
        });
    }

    private void createSelectionPart(Composite parent) {
        SashForm selectionPartSashForm = new SashForm(parent, 0);
        Composite forPartComposite = new Composite((Composite)selectionPartSashForm, 0);
        forPartComposite.setLayout((Layout)new GridLayout(1, false));
        Composite forButtonsComposite = new Composite(forPartComposite, 0);
        GridLayout gl_forButtonsComposite = new GridLayout(6, false);
        gl_forButtonsComposite.verticalSpacing = 0;
        gl_forButtonsComposite.horizontalSpacing = 0;
        gl_forButtonsComposite.marginHeight = 0;
        gl_forButtonsComposite.marginWidth = 0;
        forButtonsComposite.setLayout((Layout)gl_forButtonsComposite);
        forButtonsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label forLabel = new Label(forButtonsComposite, 0);
        forLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        forLabel.setText(Messages.DiagramTemplateEditor_64);
        Button allForButton = new Button(forButtonsComposite, 0);
        allForButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/forAll.png"));
        allForButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ArrayList<EObject> listOfTypes = new ArrayList<EObject>();
                UMLPackage umlPackage = UMLPackage.eINSTANCE;
                TreeIterator it = umlPackage.eAllContents();
                while (it.hasNext()) {
                    EObject typeInUML = (EObject)it.next();
                    if (!(typeInUML instanceof EClass)) continue;
                    if (DiagramTemplateEditor.this.targetModelResource != null) {
                        if (DiagramTemplateEditor.this.targetModelResource.getContents().isEmpty()) continue;
                        TreeIterator itTarget = DiagramTemplateEditor.this.targetModelResource.getAllContents();
                        while (itTarget.hasNext()) {
                            EObject elementInTargetModel = (EObject)itTarget.next();
                            if (typeInUML != elementInTargetModel.eClass() || listOfTypes.contains(typeInUML)) continue;
                            listOfTypes.add(typeInUML);
                        }
                        continue;
                    }
                    listOfTypes.add(typeInUML);
                }
                ListSelectionDialog dlg = new ListSelectionDialog(DiagramTemplateEditor.this.getSite().getShell(), listOfTypes, (IStructuredContentProvider)new TypesContentProvider(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)DiagramTemplateEditor.this.adapterFactory), Messages.DiagramTemplateEditor_67);
                dlg.setTitle(Messages.DiagramTemplateEditor_68);
                dlg.open();
                Object[] results = dlg.getResult();
                if (results != null) {
                    Object[] objectArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof EClass && !DiagramTemplateEditor.this.containsElement((EObject)((EClass)object), (List<?>)DiagramTemplateEditor.this.currentDiagramDefinition.getSelection())) {
                            Selection selection = DiagramTemplateEditor.this.diagramtemplateFactory.createSelection();
                            selection.setKind(SelectionKind.FOR_ALL);
                            selection.setRecursively(false);
                            selection.setSubTypes(false);
                            selection.setStereotypedBy("");
                            selection.setElement((EObject)((EClass)object));
                            AddCommand command = new AddCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.currentDiagramDefinition, DiagramTemplateEditor.this.currentDiagramDefinition.eClass().getEStructuralFeature("selection"), (Object)selection);
                            DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                        }
                        ++n2;
                    }
                    DiagramTemplateEditor.this.forTreeViewer.refresh();
                }
            }
        });
        allForButton.setText(Messages.DiagramTemplateEditor_71);
        this.specificForButton = new Button(forButtonsComposite, 0);
        this.specificForButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/specific.gif"));
        this.specificForButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (DiagramTemplateEditor.this.targetModelResource != null) {
                    CheckedTreeSelectionDialog dlg = new CheckedTreeSelectionDialog(DiagramTemplateEditor.this.getSite().getShell(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)DiagramTemplateEditor.this.adapterFactory), (ITreeContentProvider)new AdapterFactoryContentProvider((AdapterFactory)DiagramTemplateEditor.this.adapterFactory));
                    dlg.setInput((Object)DiagramTemplateEditor.this.targetModelResource);
                    dlg.setTitle(Messages.DiagramTemplateEditor_74);
                    dlg.open();
                    Object[] results = dlg.getResult();
                    if (results != null) {
                        Object[] objectArray = results;
                        int n = results.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (object instanceof EObject && !DiagramTemplateEditor.this.containsElement((EObject)object, (List<?>)DiagramTemplateEditor.this.currentDiagramDefinition.getSelection())) {
                                Selection selection = DiagramTemplateEditor.this.diagramtemplateFactory.createSelection();
                                selection.setKind(SelectionKind.SPECIFIC);
                                selection.setRecursively(false);
                                selection.setSubTypes(false);
                                selection.setStereotypedBy("");
                                selection.setElement((EObject)object);
                                AddCommand command = new AddCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)DiagramTemplateEditor.this.currentDiagramDefinition, DiagramTemplateEditor.this.currentDiagramDefinition.eClass().getEStructuralFeature("selection"), (Object)selection);
                                DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                            }
                            ++n2;
                        }
                        DiagramTemplateEditor.this.forTreeViewer.refresh();
                    }
                }
            }
        });
        this.specificForButton.setText(Messages.DiagramTemplateEditor_77);
        this.specificForButton.setEnabled(false);
        Button removeForButton = new Button(forButtonsComposite, 0);
        removeForButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.forTreeViewer.getSelection();
                if (selection != null && selection instanceof ITreeSelection) {
                    for (Object object : (ITreeSelection)selection) {
                        RemoveCommand command;
                        if (object instanceof Selection) {
                            command = new RemoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, ((Selection)object).eContainer(), ((Selection)object).eContainer().eClass().getEStructuralFeature("selection"), object);
                            DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                            continue;
                        }
                        if (!(object instanceof SelectionRef)) continue;
                        command = new RemoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, ((SelectionRef)object).eContainer(), ((SelectionRef)object).eContainer().eClass().getEStructuralFeature("selectionRef"), object);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    }
                    DiagramTemplateEditor.this.forTreeViewer.refresh();
                }
            }
        });
        removeForButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/delete.gif"));
        Button moveUpForButton = new Button(forButtonsComposite, 0);
        moveUpForButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.forTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    AbstractSelection abstractSelection = (AbstractSelection)((IStructuredSelection)selection).getFirstElement();
                    if (abstractSelection instanceof Selection) {
                        MoveCommand command = new MoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, abstractSelection.eContainer(), abstractSelection.eContainer().eClass().getEStructuralFeature("selection"), (Object)abstractSelection, ((DiagramDefinition)abstractSelection.eContainer()).getSelection().indexOf((Object)abstractSelection) - 1);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    } else if (abstractSelection instanceof SelectionRef) {
                        MoveCommand command = new MoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, abstractSelection.eContainer(), abstractSelection.eContainer().eClass().getEStructuralFeature("selectionRef"), (Object)abstractSelection, ((AbstractSelection)abstractSelection.eContainer()).getSelectionRef().indexOf((Object)abstractSelection) - 1);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    }
                    DiagramTemplateEditor.this.forTreeViewer.refresh();
                }
            }
        });
        moveUpForButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/up.gif"));
        Button moveDownForButton = new Button(forButtonsComposite, 0);
        moveDownForButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.forTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    AbstractSelection abstractSelection = (AbstractSelection)((IStructuredSelection)selection).getFirstElement();
                    if (abstractSelection instanceof Selection) {
                        MoveCommand command = new MoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, abstractSelection.eContainer(), abstractSelection.eContainer().eClass().getEStructuralFeature("selection"), (Object)abstractSelection, ((DiagramDefinition)abstractSelection.eContainer()).getSelection().indexOf((Object)abstractSelection) + 1);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    } else if (abstractSelection instanceof SelectionRef) {
                        MoveCommand command = new MoveCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, abstractSelection.eContainer(), abstractSelection.eContainer().eClass().getEStructuralFeature("selectionRef"), (Object)abstractSelection, ((AbstractSelection)abstractSelection.eContainer()).getSelectionRef().indexOf((Object)abstractSelection) + 1);
                        DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    }
                    DiagramTemplateEditor.this.forTreeViewer.refresh();
                }
            }
        });
        moveDownForButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/down.gif"));
        this.forTreeViewer = new TreeViewer(forPartComposite, 67584);
        this.forTree = this.forTreeViewer.getTree();
        this.forTree.setHeaderVisible(true);
        this.forTreeViewer.setAutoExpandLevel(-1);
        this.forTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn selectionTreeViewerColumn = new TreeViewerColumn(this.forTreeViewer, 0);
        TreeColumn selectionTreeColumn = selectionTreeViewerColumn.getColumn();
        selectionTreeColumn.setWidth(200);
        selectionTreeColumn.setText(Messages.DiagramTemplateEditor_90);
        TreeViewerColumn recursivelyTreeViewerColumn = new TreeViewerColumn(this.forTreeViewer, 0);
        TreeColumn recursivelyTreeColumn = recursivelyTreeViewerColumn.getColumn();
        recursivelyTreeColumn.setWidth(70);
        recursivelyTreeColumn.setText(Messages.DiagramTemplateEditor_91);
        recursivelyTreeViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.forTreeViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof Selection) {
                    SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)((Selection)element), ((Selection)element).eClass().getEStructuralFeature("recursively"), (Object)((Boolean)value));
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    this.getViewer().update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof Selection) {
                    return ((Selection)element).isRecursively();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof Selection && ((Selection)element).getKind() == SelectionKind.FOR_ALL) {
                    return new CheckboxCellEditor((Composite)DiagramTemplateEditor.this.forTree);
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TreeViewerColumn subTypesTreeViewerColumn = new TreeViewerColumn(this.forTreeViewer, 0);
        TreeColumn subTypesTreeColumn = subTypesTreeViewerColumn.getColumn();
        subTypesTreeColumn.setWidth(70);
        subTypesTreeColumn.setText(Messages.DiagramTemplateEditor_93);
        subTypesTreeViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.forTreeViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof AbstractSelection) {
                    SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)((AbstractSelection)element), ((AbstractSelection)element).eClass().getEStructuralFeature("subTypes"), (Object)((Boolean)value));
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    this.getViewer().update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof AbstractSelection) {
                    return ((AbstractSelection)element).isSubTypes();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof AbstractSelection && ((AbstractSelection)element).getKind() == SelectionKind.FOR_ALL) {
                    return new CheckboxCellEditor((Composite)DiagramTemplateEditor.this.forTree);
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TreeViewerColumn stereotypeTreeViewerColumn = new TreeViewerColumn(this.forTreeViewer, 0);
        TreeColumn stereotypeTreeColumn = stereotypeTreeViewerColumn.getColumn();
        stereotypeTreeColumn.setWidth(200);
        stereotypeTreeColumn.setText(Messages.DiagramTemplateEditor_95);
        stereotypeTreeViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.forTreeViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof AbstractSelection) {
                    SetCommand command = new SetCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)((AbstractSelection)element), ((AbstractSelection)element).eClass().getEStructuralFeature("stereotypedBy"), (Object)((String)value));
                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                    this.getViewer().update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof AbstractSelection) {
                    if (((AbstractSelection)element).getStereotypedBy() == null) {
                        return "";
                    }
                    return ((AbstractSelection)element).getStereotypedBy();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof AbstractSelection && ((AbstractSelection)element).getKind() == SelectionKind.FOR_ALL) {
                    return new TextCellEditor((Composite)DiagramTemplateEditor.this.forTree);
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.forTreeViewer.setContentProvider((IContentProvider)new ForContentProvider());
        this.forTreeViewer.setLabelProvider((IBaseLabelProvider)new ForLabelProvider());
        this.forTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Object selectionItem;
                    DiagramTemplateEditor.this.whatTableViewer.setInput((Object)selection);
                    DiagramTemplateEditor.this.whatTableViewer.refresh();
                    if (selection instanceof IStructuredSelection && (selectionItem = ((IStructuredSelection)selection).getFirstElement()) instanceof AbstractSelection) {
                        if (((AbstractSelection)selectionItem).getKind() == SelectionKind.FOR_ALL) {
                            DiagramTemplateEditor.this.specificWhatButton.setEnabled(false);
                        } else if (((AbstractSelection)selectionItem).getKind() == SelectionKind.SPECIFIC) {
                            DiagramTemplateEditor.this.specificWhatButton.setEnabled(true);
                        }
                    }
                }
            }
        });
        Composite whatPartComposite = new Composite((Composite)selectionPartSashForm, 0);
        whatPartComposite.setLayout((Layout)new GridLayout(1, false));
        Composite whatButtonsComposite = new Composite(whatPartComposite, 0);
        GridLayout gl_whatButtonsComposite = new GridLayout(3, false);
        gl_whatButtonsComposite.marginHeight = 0;
        gl_whatButtonsComposite.marginWidth = 0;
        gl_whatButtonsComposite.verticalSpacing = 0;
        gl_whatButtonsComposite.horizontalSpacing = 0;
        whatButtonsComposite.setLayout((Layout)gl_whatButtonsComposite);
        whatButtonsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        whatButtonsComposite.setBounds(0, 0, 64, 64);
        Label whatLabel = new Label(whatButtonsComposite, 0);
        whatLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        whatLabel.setText(Messages.DiagramTemplateEditor_98);
        Button allWhatButton = new Button(whatButtonsComposite, 0);
        allWhatButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection selection = DiagramTemplateEditor.this.whatTableViewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    EReference eReference = (EReference)((IStructuredSelection)selection).getFirstElement();
                    ListSelectionDialog dlg = new ListSelectionDialog(DiagramTemplateEditor.this.getSite().getShell(), (Object)eReference, (IStructuredContentProvider)new TypesAvailableFromEReferenceContentProvider(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)DiagramTemplateEditor.this.adapterFactory), Messages.DiagramTemplateEditor_99);
                    dlg.setTitle(Messages.DiagramTemplateEditor_100);
                    dlg.open();
                    ISelection forSelection = DiagramTemplateEditor.this.forTreeViewer.getSelection();
                    if (forSelection != null) {
                        Object[] results;
                        AbstractSelection selectionItem;
                        if (forSelection instanceof ITreeSelection && (selectionItem = (AbstractSelection)((ITreeSelection)forSelection).getFirstElement()) != null && (results = dlg.getResult()) != null) {
                            Object[] objectArray = results;
                            int n = results.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object = objectArray[n2];
                                if (object instanceof EClass && !DiagramTemplateEditor.this.containsElement((EObject)((EClass)object), (List<?>)selectionItem.getSelectionRef())) {
                                    SelectionRef selectionRef = DiagramTemplateEditor.this.diagramtemplateFactory.createSelectionRef();
                                    selectionRef.setKind(SelectionKind.FOR_ALL);
                                    selectionRef.setElement((EObject)((EClass)object));
                                    selectionRef.setSubTypes(false);
                                    selectionRef.setStereotypedBy("");
                                    selectionRef.setEReference((EObject)eReference);
                                    AddCommand command = new AddCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)selectionItem, selectionItem.eClass().getEStructuralFeature("selectionRef"), (Object)selectionRef);
                                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                                }
                                ++n2;
                            }
                        }
                        DiagramTemplateEditor.this.forTreeViewer.refresh();
                    }
                }
            }
        });
        allWhatButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/forAllRef.png"));
        allWhatButton.setText(Messages.DiagramTemplateEditor_105);
        this.specificWhatButton = new Button(whatButtonsComposite, 0);
        this.specificWhatButton.setImage(ResourceManager.getPluginImage("org.eclipse.papyrus.diagramtemplate.editor", "icons/full/obj16/specificRef.gif"));
        this.specificWhatButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ISelection forSelection;
                ISelection selection = DiagramTemplateEditor.this.whatTableViewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && !selection.isEmpty() && (forSelection = DiagramTemplateEditor.this.forTreeViewer.getSelection()) != null) {
                    AbstractSelection selectionItem;
                    if (forSelection instanceof ITreeSelection && (selectionItem = (AbstractSelection)((ITreeSelection)forSelection).getFirstElement()) != null) {
                        EReference eReference = (EReference)((IStructuredSelection)selection).getFirstElement();
                        Object value = selectionItem.getElement().eGet((EStructuralFeature)eReference);
                        ArrayList<EObject> valueToShow = new ArrayList<EObject>();
                        if (value instanceof List) {
                            valueToShow.addAll((Collection)value);
                        } else if (value instanceof EObject) {
                            valueToShow.add((EObject)value);
                        }
                        ListSelectionDialog dlg = new ListSelectionDialog(DiagramTemplateEditor.this.getSite().getShell(), valueToShow, (IStructuredContentProvider)new ElementsAvailableContentProvider(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)DiagramTemplateEditor.this.adapterFactory), Messages.DiagramTemplateEditor_108);
                        dlg.setTitle(Messages.DiagramTemplateEditor_109);
                        dlg.open();
                        Object[] results = dlg.getResult();
                        if (results != null) {
                            Object[] objectArray = results;
                            int n = results.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object = objectArray[n2];
                                if (object instanceof EObject && !DiagramTemplateEditor.this.containsElement((EObject)object, (List<?>)selectionItem.getSelectionRef())) {
                                    SelectionRef selectionRef = DiagramTemplateEditor.this.diagramtemplateFactory.createSelectionRef();
                                    selectionRef.setKind(SelectionKind.SPECIFIC);
                                    selectionRef.setElement((EObject)object);
                                    selectionRef.setEReference((EObject)eReference);
                                    selectionRef.setStereotypedBy("");
                                    selectionRef.setSubTypes(false);
                                    AddCommand command = new AddCommand((EditingDomain)DiagramTemplateEditor.this.editingDomain, (EObject)selectionItem, selectionItem.eClass().getEStructuralFeature("selectionRef"), (Object)selectionRef);
                                    DiagramTemplateEditor.this.editingDomain.getCommandStack().execute((Command)command);
                                }
                                ++n2;
                            }
                        }
                    }
                    DiagramTemplateEditor.this.forTreeViewer.refresh();
                }
            }
        });
        this.specificWhatButton.setText(Messages.DiagramTemplateEditor_112);
        this.specificWhatButton.setEnabled(false);
        this.whatTableViewer = new TableViewer(whatPartComposite, 67584);
        this.whatTable = this.whatTableViewer.getTable();
        this.whatTableViewer.setContentProvider((IContentProvider)new WhatContentProvider());
        this.whatTableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.whatTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        selectionPartSashForm.setWeights(new int[]{1, 1});
    }

    private void createEditionPart(Composite parent) {
        SashForm editionPartSashForm = new SashForm(parent, 512);
        this.createDiagramInformationPart((Composite)editionPartSashForm);
        this.createSelectionPart((Composite)editionPartSashForm);
        editionPartSashForm.setWeights(new int[]{1, 1});
    }

    private void createTemplatePart(Composite parent) {
        SashForm templatePartSashForm = new SashForm(parent, 0);
        templatePartSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createDiagramDefinitionPart((Composite)templatePartSashForm);
        this.createEditionPart((Composite)templatePartSashForm);
        templatePartSashForm.setWeights(new int[]{140, 808});
    }

    public void createPartControl(Composite parent) {
        if (this.createModel()) {
            parent.setLayout((Layout)new GridLayout(1, false));
            this.createloadPart(parent);
            this.createTemplatePart(parent);
            this.createNewDiagramDefinition();
            if (this.targetModelResource != null) {
                this.targetModelPathText.setText(this.targetModelResource.getURI().toString());
                this.selectRootButton.setEnabled(true);
                this.loadModelButton.setEnabled(false);
                this.specificForButton.setEnabled(true);
                this.executeButton.setEnabled(true);
            } else {
                this.clearTemplate();
            }
        }
    }

    public void setFocus() {
    }
}

