/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagramtemplate.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.diagramtemplate.AbstractSelection;
import org.eclipse.papyrus.diagramtemplate.DiagramDefinition;
import org.eclipse.papyrus.diagramtemplate.Selection;
import org.eclipse.papyrus.diagramtemplate.SelectionKind;
import org.eclipse.papyrus.diagramtemplate.SelectionRef;
import org.eclipse.papyrus.diagramtemplate.Template;
import org.eclipse.papyrus.diagramtemplate.editor.provider.DiagramKindContentProvider;
import org.eclipse.papyrus.diagramtemplate.launcher.DiagramTemplateLauncherReport;
import org.eclipse.papyrus.diagramtemplate.utils.Messages;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramTemplateLauncher {
    private static DiagramTemplateLauncher instance = null;
    protected HashMap<EObject, CreationReportKind> creationReport;
    protected HashMap<String, AbstractSelection> diagramsCreated;
    protected List<View> elementProcessed = new ArrayList<View>();
    protected List<String> diagramsInResource;
    protected List<String> diagramCategories;

    private DiagramTemplateLauncher() {
    }

    public static final synchronized DiagramTemplateLauncher getInstance() {
        if (instance == null) {
            instance = new DiagramTemplateLauncher();
        }
        return instance;
    }

    protected void initializeDiagramCategories() {
        this.diagramCategories = new ArrayList<String>();
        for (DiagramCategoryDescriptor diagramCategoryDescriptor : DiagramCategoryRegistry.getInstance().getDiagramCategories()) {
            this.diagramCategories.add(diagramCategoryDescriptor.getLabel());
        }
    }

    protected CreationCommandDescriptor getCreation(String commandID) {
        DiagramKindContentProvider provider = new DiagramKindContentProvider();
        List<Object> diagramsKindlist = Arrays.asList(provider.getElements(this.diagramCategories));
        for (Object object : diagramsKindlist) {
            CreationCommandDescriptor command = (CreationCommandDescriptor)object;
            if (command.getCommandId().compareTo(commandID) != 0) continue;
            return command;
        }
        return null;
    }

    protected void processRecursively(EditPart actualEditPart, EObject elementToShow, SelectionRef selectionRef, DiagramEditor activeEditor) {
        EditPartViewer viewer = actualEditPart.getViewer();
        Map map = viewer.getEditPartRegistry();
        HashMap mapCopy = new HashMap(map);
        Iterator it = mapCopy.keySet().iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            String elementToShowID;
            GraphicalEditPart editPart;
            String editPartSemanticElementID;
            Object view = it.next();
            Object value = mapCopy.get(view);
            if (!(value instanceof GraphicalEditPart) || !(editPartSemanticElementID = (editPart = (GraphicalEditPart)value).resolveSemanticElement().eResource().getURIFragment(editPart.resolveSemanticElement())).equals(elementToShowID = elementToShow.eResource().getURIFragment(elementToShow))) continue;
            boolean foundParentWithElementToShowAsElement = false;
            EditPart elementToProcess = editPart.getParent();
            while (elementToProcess != null && !foundParentWithElementToShowAsElement) {
                String elementToProcessSemanticElementID;
                if (elementToProcess instanceof GraphicalEditPart && (elementToProcessSemanticElementID = ((GraphicalEditPart)elementToProcess).resolveSemanticElement().eResource().getURIFragment(((GraphicalEditPart)elementToProcess).resolveSemanticElement())).equals(elementToShowID)) {
                    foundParentWithElementToShowAsElement = true;
                }
                elementToProcess = elementToProcess.getParent();
            }
            if (foundParentWithElementToShowAsElement || this.elementProcessed.contains(view)) continue;
            this.addElementsFor((List<?>)selectionRef.getSelectionRef(), elementToShow, activeEditor, (EditPart)editPart);
            this.elementProcessed.add((View)view);
            found = true;
        }
    }

    protected void addElementsFor(List<?> selectionList, EObject root, DiagramEditor activeEditor, EditPart editPartToShowIn) {
        for (Object object : selectionList) {
            EditPart actualEditPart;
            if (!(object instanceof SelectionRef)) continue;
            SelectionRef selectionRef = (SelectionRef)object;
            Object result = root.eGet((EStructuralFeature)selectionRef.getEReference());
            ArrayList<EObject> resultsToProcess = new ArrayList<EObject>();
            if (result instanceof List) {
                resultsToProcess.addAll((Collection)result);
            } else {
                resultsToProcess.add((EObject)result);
            }
            if (selectionRef.getKind() == SelectionKind.FOR_ALL) {
                ArrayList<EObject> resultsToShow = new ArrayList<EObject>();
                for (EObject elementToMatch : resultsToProcess) {
                    if (!this.matchStereotypedBy(elementToMatch, selectionRef.getStereotypedBy())) continue;
                    if (selectionRef.isSubTypes()) {
                        if (!elementToMatch.eClass().getEAllSuperTypes().contains((Object)selectionRef.getElement()) && elementToMatch.eClass() != selectionRef.getElement()) continue;
                        resultsToShow.add(elementToMatch);
                        continue;
                    }
                    if (elementToMatch.eClass() != selectionRef.getElement()) continue;
                    resultsToShow.add(elementToMatch);
                }
                int i = 0;
                for (EObject elementToShow : resultsToShow) {
                    actualEditPart = this.showElementIn(elementToShow, activeEditor, editPartToShowIn, i);
                    this.processRecursively(actualEditPart, elementToShow, selectionRef, activeEditor);
                    ++i;
                }
                continue;
            }
            for (EObject eObject : resultsToProcess) {
                String elementID;
                String eObjectID = eObject.eResource().getURIFragment(eObject);
                if (!eObjectID.equals(elementID = selectionRef.getElement().eResource().getURIFragment(selectionRef.getElement()))) continue;
                actualEditPart = this.showElementIn(eObject, activeEditor, editPartToShowIn, 0);
                this.processRecursively(actualEditPart, eObject, selectionRef, activeEditor);
            }
        }
    }

    protected void findAllChildren(List<EditPart> list, EditPart root) {
        list.addAll(root.getChildren());
        for (Object editPart : root.getChildren()) {
            if (!(editPart instanceof EditPart)) continue;
            this.findAllChildren(list, (EditPart)editPart);
        }
    }

    protected EditPart showElementIn(EObject elementToShow, DiagramEditor activeEditor, EditPart editPart, int position) {
        EditPart returnEditPart = null;
        if (elementToShow instanceof Element) {
            DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
            ArrayList<Element> list = new ArrayList<Element>();
            list.add((Element)elementToShow);
            dropObjectsRequest.setObjects(list);
            dropObjectsRequest.setLocation(new Point(20, 100 * position));
            org.eclipse.gef.commands.Command commandDrop = editPart.getCommand((Request)dropObjectsRequest);
            boolean processChildren = false;
            if (commandDrop == null) {
                processChildren = true;
            } else if (commandDrop.canExecute()) {
                activeEditor.getDiagramEditDomain().getDiagramCommandStack().execute(commandDrop);
                returnEditPart = editPart;
                this.creationReport.put(elementToShow, CreationReportKind.SUCCESS);
            } else {
                processChildren = true;
            }
            if (processChildren) {
                boolean found = false;
                ArrayList<EditPart> childrenList = new ArrayList<EditPart>();
                this.findAllChildren(childrenList, editPart);
                for (EditPart child : childrenList) {
                    org.eclipse.gef.commands.Command commandDropChild;
                    if (!(child instanceof EditPart) || (commandDropChild = child.getCommand((Request)dropObjectsRequest)) == null || !commandDropChild.canExecute()) continue;
                    activeEditor.getDiagramEditDomain().getDiagramCommandStack().execute(commandDropChild);
                    found = true;
                    returnEditPart = child;
                    this.creationReport.put(elementToShow, CreationReportKind.SUCCESS);
                    break;
                }
                if (!found) {
                    this.creationReport.put(elementToShow, CreationReportKind.FAIL);
                    returnEditPart = editPart;
                }
            }
        }
        return returnEditPart;
    }

    protected boolean matchStereotypedBy(EObject element, String stereotypedBy) {
        if (element instanceof Element) {
            stereotypedBy = stereotypedBy.replaceAll(" ", "");
            String[] stereotypes = stereotypedBy.split(",");
            boolean matchStereotypes = true;
            String[] stringArray = stereotypes;
            int n = stereotypes.length;
            int n2 = 0;
            while (n2 < n) {
                String stereo = stringArray[n2];
                if (stereo != null && stereo.length() > 0) {
                    if (((Element)element).getAppliedStereotype(stereo) != null) {
                        matchStereotypes = true;
                    } else {
                        matchStereotypes = false;
                        break;
                    }
                }
                ++n2;
            }
            return matchStereotypes;
        }
        return false;
    }

    protected void createDiagramFor(List<?> selectionList, DiagramDefinition diagramDefinition, ModelSet modelSet) {
        for (Object object : selectionList) {
            TreeIterator it;
            EObject root;
            if (!(object instanceof AbstractSelection)) continue;
            AbstractSelection selection = (AbstractSelection)object;
            CreationCommandDescriptor creationCommandDescriptor = this.getCreation(diagramDefinition.getDiagramKind());
            if (creationCommandDescriptor == null || (root = diagramDefinition.getFromRoot() == null ? ((Template)diagramDefinition.eContainer()).getTargetRoot() : diagramDefinition.getFromRoot()) == null) continue;
            if (selection.getKind() == SelectionKind.FOR_ALL) {
                ArrayList<EObject> content = new ArrayList<EObject>();
                if (selection instanceof Selection) {
                    if (((Selection)selection).isRecursively()) {
                        it = root.eAllContents();
                        while (it.hasNext()) {
                            EObject eObject = (EObject)it.next();
                            content.add(eObject);
                        }
                    } else {
                        content.addAll((Collection<EObject>)root.eContents());
                    }
                    content.add(root);
                } else {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.DiagramTemplateLauncher_3, (String)Messages.DiagramTemplateLauncher_4);
                }
                for (EObject eObject : content) {
                    EObject diagram;
                    TreeIterator it2;
                    if (!this.matchStereotypedBy(eObject, selection.getStereotypedBy())) continue;
                    String name = diagramDefinition.getPrefix();
                    name = eObject instanceof NamedElement ? String.valueOf(name) + ((NamedElement)eObject).getName() : String.valueOf(name) + eObject.toString();
                    if (selection.isSubTypes()) {
                        if (!eObject.eClass().getEAllSuperTypes().contains((Object)selection.getElement()) && eObject.eClass() != selection.getElement()) continue;
                        try {
                            creationCommandDescriptor.getCommand().createDiagram(modelSet, eObject, name);
                            it2 = NotationUtils.getNotationResource((ModelSet)modelSet).getAllContents();
                            while (it2.hasNext()) {
                                diagram = (EObject)it2.next();
                                if (!(diagram instanceof Diagram) || this.diagramsInResource.contains(diagram.eResource().getURIFragment(diagram))) continue;
                                this.diagramsCreated.put(diagram.eResource().getURIFragment(diagram), selection);
                                this.diagramsInResource.add(diagram.eResource().getURIFragment(diagram));
                                this.creationReport.put(eObject, CreationReportKind.SUCCESS);
                            }
                        }
                        catch (BackboneException e) {
                            e.printStackTrace(System.out);
                        }
                        continue;
                    }
                    if (eObject.eClass() != selection.getElement()) continue;
                    try {
                        creationCommandDescriptor.getCommand().createDiagram(modelSet, eObject, name);
                        it2 = NotationUtils.getNotationResource((ModelSet)modelSet).getAllContents();
                        while (it2.hasNext()) {
                            diagram = (EObject)it2.next();
                            if (!(diagram instanceof Diagram) || this.diagramsInResource.contains(diagram.eResource().getURIFragment(diagram))) continue;
                            this.diagramsCreated.put(diagram.eResource().getURIFragment(diagram), selection);
                            this.diagramsInResource.add(diagram.eResource().getURIFragment(diagram));
                            this.creationReport.put(eObject, CreationReportKind.SUCCESS);
                        }
                    }
                    catch (BackboneException e) {
                        e.printStackTrace(System.out);
                    }
                }
                continue;
            }
            if (selection.getKind() != SelectionKind.SPECIFIC) continue;
            String name = diagramDefinition.getPrefix();
            name = selection.getElement() instanceof NamedElement ? String.valueOf(name) + ((NamedElement)selection.getElement()).getName() : String.valueOf(name) + selection.getElement().toString();
            try {
                creationCommandDescriptor.getCommand().createDiagram(modelSet, selection.getElement(), name);
                it = NotationUtils.getNotationResource((ModelSet)modelSet).getAllContents();
                while (it.hasNext()) {
                    EObject diagram = (EObject)it.next();
                    if (!(diagram instanceof Diagram) || this.diagramsInResource.contains(diagram.eResource().getURIFragment(diagram))) continue;
                    this.diagramsCreated.put(diagram.eResource().getURIFragment(diagram), selection);
                    this.diagramsInResource.add(diagram.eResource().getURIFragment(diagram));
                    this.creationReport.put(selection.getElement(), CreationReportKind.SUCCESS);
                }
            }
            catch (BackboneException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    protected void arrangeRecursively(EditPart editpart) {
        ArrangeRequest request = new ArrangeRequest("arrange_deferred");
        ArrayList listToArrange = new ArrayList();
        listToArrange.addAll(editpart.getChildren());
        if (!listToArrange.isEmpty()) {
            for (Object element : editpart.getChildren()) {
                if (!(element instanceof EditPart)) continue;
                this.arrangeRecursively((EditPart)element);
            }
            request.setViewAdaptersToArrange(listToArrange);
            org.eclipse.gef.commands.Command command = editpart.getCommand((Request)request);
            command.execute();
        }
    }

    public void execute(Template template) {
        this.initializeDiagramCategories();
        this.diagramsInResource = new ArrayList<String>();
        this.diagramsCreated = new HashMap();
        this.creationReport = new HashMap();
        if (template != null) {
            DiResourceSet modelSet = new DiResourceSet();
            if (template.getTargetRoot().eResource() != null) {
                String targetModelLocation = template.getTargetRoot().eResource().getURI().toPlatformString(false);
                IFile targetModelfile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(targetModelLocation));
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(targetModelfile.getFullPath().removeFileExtension().toString()) + ".di"));
                if (file.exists()) {
                    try {
                        modelSet.loadModels(file);
                    }
                    catch (ModelMultiException ex) {
                        ex.printStackTrace(System.out);
                    }
                    try {
                        ExtensionServicesRegistry registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
                        registry.add(ModelSet.class, Integer.MAX_VALUE, (Object)modelSet);
                        try {
                            registry.startRegistry();
                        }
                        catch (ServiceException serviceException) {
                            // empty catch block
                        }
                        TreeIterator it = NotationUtils.getNotationResource((ModelSet)modelSet).getAllContents();
                        while (it.hasNext()) {
                            EObject diagram = (EObject)it.next();
                            if (!(diagram instanceof Diagram)) continue;
                            this.diagramsInResource.add(diagram.eResource().getURIFragment(diagram));
                        }
                        if (!template.getDiagramDefinitions().isEmpty()) {
                            for (DiagramDefinition diagramDefinition : template.getDiagramDefinitions()) {
                                this.createDiagramFor((List<?>)diagramDefinition.getSelection(), diagramDefinition, (ModelSet)modelSet);
                            }
                        }
                        try {
                            modelSet.save((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.out);
                        }
                        try {
                            registry.disposeRegistry();
                        }
                        catch (ServiceException e) {}
                    }
                    catch (ServiceException ex) {
                        ex.printStackTrace(System.out);
                    }
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page != null) {
                        try {
                            final IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                            if (editor instanceof IMultiDiagramEditor) {
                                final ServicesRegistry services = ((IMultiDiagramEditor)editor).getServicesRegistry();
                                TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)services.getService(TransactionalEditingDomain.class);
                                RecordingCommand openPagesCommand = new RecordingCommand(editingDomain, "Open created pages"){

                                    protected void doExecute() {
                                        try {
                                            System.out.println("Executing");
                                            IPageManager pageManager = (IPageManager)services.getService(IPageManager.class);
                                            System.out.println("Close all pages");
                                            pageManager.closeAllOpenedPages();
                                            for (Object pageDiagram : pageManager.allPages()) {
                                                String pageID;
                                                if (!(pageDiagram instanceof Diagram) || !DiagramTemplateLauncher.this.diagramsCreated.containsKey(pageID = ((Diagram)pageDiagram).eResource().getURIFragment((EObject)((Diagram)pageDiagram)))) continue;
                                                System.out.println("Open page");
                                                pageManager.openPage(pageDiagram);
                                                IEditorPart activeEditor = ((PapyrusMultiDiagramEditor)editor).getActiveEditor();
                                                if (!(activeEditor instanceof DiagramEditor)) continue;
                                                Object result = activeEditor.getAdapter(GraphicalViewer.class);
                                                if (result != null && result instanceof GraphicalViewer) {
                                                    DiagramEditPart diagramEditPart = (DiagramEditPart)((GraphicalViewer)result).getEditPartRegistry().get(pageDiagram);
                                                    AbstractSelection selection = DiagramTemplateLauncher.this.diagramsCreated.get(pageID);
                                                    DiagramTemplateLauncher.this.addElementsFor((List<?>)selection.getSelectionRef(), ((Diagram)pageDiagram).getElement(), (DiagramEditor)activeEditor, (EditPart)diagramEditPart);
                                                    DiagramTemplateLauncher.this.arrangeRecursively((EditPart)diagramEditPart);
                                                }
                                                DiagramTemplateLauncher.this.diagramsCreated.remove(pageID);
                                            }
                                        }
                                        catch (ServiceException ex) {
                                            ex.printStackTrace(System.out);
                                        }
                                    }
                                };
                                editingDomain.getCommandStack().execute((Command)openPagesCommand);
                            }
                            DiagramTemplateLauncherReport.getInstance().showReport(this.creationReport);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace(System.out);
                        }
                        catch (ServiceException e) {
                            e.printStackTrace(System.out);
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.DiagramTemplateLauncher_6, (String)Messages.DiagramTemplateLauncher_7);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreationReportKind {
        SUCCESS,
        FAIL;

    }
}

