/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.generator.xtend;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ClientSelectorGen {
    public static CharSequence generateValidationContext(Stereotype stereotype) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Created by the Papyrus DSML plugin generator");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"package ");
        String _topPkg = Utils.getTopPkg();
        _builder.append((Object)_topPkg, "");
        _builder.append((Object)".selectors;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.validation.model.IClientSelector;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.papyrus.uml.service.validation.StereotypeUtil;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This class filters (selects) passed stereotype applications. It returns true, if the");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* associated stereotype (or one of its super-stereotypes) has the name '[stereotype.name/]'.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = stereotype.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"ClientSelector implements IClientSelector {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean selects(Object stereoApplicationObj) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return StereotypeUtil.checkStereoApplication(stereoApplicationObj, \"");
        String _name_1 = stereotype.getName();
        _builder.append((Object)_name_1, "\t\t");
        _builder.append((Object)"\"); //$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public static void generate(Resource input, IPFileSystemAccess fsa) {
        TreeIterator _allContents = input.getAllContents();
        UnmodifiableIterator contentIterator = Iterators.filter((Iterator)_allContents, Stereotype.class);
        while (contentIterator.hasNext()) {
            Stereotype stereotype = (Stereotype)contentIterator.next();
            String _topPkg = Utils.getTopPkg();
            String _replaceAll = _topPkg.replaceAll("\\.", "/");
            String _plus = String.valueOf(_replaceAll) + "/selectors/";
            String _name = stereotype.getName();
            String _plus_1 = String.valueOf(_plus) + _name;
            String fileName = String.valueOf(_plus_1) + "ClientSelector.java";
            CharSequence _generateValidationContext = ClientSelectorGen.generateValidationContext(stereotype);
            String _string = _generateValidationContext.toString();
            fsa.generateFile(fileName, _string);
        }
    }
}

