/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.generator.xtend;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ConstraintGen {
    public static CharSequence generateConstraint(Constraint constraint) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Created by the Papyrus DSML plugin generator");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"package ");
        String _topPkg = Utils.getTopPkg();
        _builder.append((Object)_topPkg, "");
        _builder.append((Object)".constraints;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.core.runtime.IStatus;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.validation.AbstractModelConstraint;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.validation.IValidationContext;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.ecore.EObject;");
        _builder.newLine();
        boolean _isStaticProfile = Utils.isStaticProfile();
        boolean bl = _not = !_isStaticProfile;
        if (_not) {
            _builder.append((Object)"import org.eclipse.uml2.uml.Element;");
            _builder.newLine();
            _builder.append((Object)"import org.eclipse.uml2.uml.Stereotype;");
            _builder.newLine();
            _builder.append((Object)"import org.eclipse.uml2.uml.util.UMLUtil;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = constraint.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Constraint extends AbstractModelConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public IStatus validate(IValidationContext ctx) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"EObject target = ctx.getTarget();");
        _builder.newLine();
        _builder.newLine();
        Boolean _isConstraintForStereotype = Utils.isConstraintForStereotype((Constraint)constraint);
        if (_isConstraintForStereotype.booleanValue()) {
            _builder.append((Object)"\t\t");
            String qStereotypeName = Utils.getConstraintForStereotype((Constraint)constraint);
            _builder.newLineIfNotEmpty();
            boolean _isStaticProfile_1 = Utils.isStaticProfile();
            if (_isStaticProfile_1) {
                _builder.append((Object)"\t\t");
                String qStereotypeNameJava = qStereotypeName.replace("::", ".");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (target instanceof ");
                _builder.append((Object)qStereotypeNameJava, "\t\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"if (evaluateConstraint((");
                _builder.append((Object)qStereotypeNameJava, "\t\t\t");
                _builder.append((Object)") target)) {");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Stereotype stereotype = UMLUtil.getStereotype(target);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (stereotype.getQualifiedName().equals(\"");
                _builder.append((Object)qStereotypeName, "\t\t");
                _builder.append((Object)"\")) { //$NON-NLS-1$");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"Element element = UMLUtil.getBaseElement(target);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"if (evaluateConstraint(element, stereotype)) {");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ctx.createSuccessStatus();");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"else {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ctx.createFailureStatus(\"\"); //$NON-NLS-1$ failure message is in plugin.xml");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ctx.createSuccessStatus();");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (evaluateConstraint(target)) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ctx.createSuccessStatus();");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"else {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ctx.createFailureStatus(\"\"); //$NON-NLS-1$ failure message is in plugin.xml");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        Boolean _isConstraintForStereotype_1 = Utils.isConstraintForStereotype((Constraint)constraint);
        if (_isConstraintForStereotype_1.booleanValue()) {
            boolean _notEquals;
            boolean _isStaticProfile_2 = Utils.isStaticProfile();
            if (_isStaticProfile_2) {
                _builder.append((Object)"\t");
                String qStereotypeName_1 = Utils.getConstraintForStereotype((Constraint)constraint);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String qStereotypeNameJava_1 = qStereotypeName_1.replace("::", ".");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private boolean evaluateConstraint(");
                _builder.append((Object)qStereotypeNameJava_1, "\t");
                _builder.append((Object)" self) {");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"private boolean evaluateConstraint(Element self, Stereotype appliedStereotype) {");
                _builder.newLine();
            }
            ValueSpecification _specification = constraint.getSpecification();
            String _javaConstraintBody = Utils.getJavaConstraintBody((ValueSpecification)_specification);
            boolean bl2 = _notEquals = !Objects.equal((Object)_javaConstraintBody, null);
            if (_notEquals) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                ValueSpecification _specification_1 = constraint.getSpecification();
                String _javaConstraintBody_1 = Utils.getJavaConstraintBody((ValueSpecification)_specification_1);
                _builder.append((Object)_javaConstraintBody_1, "\t\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return true;");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        Boolean _isConstraintForStereotype_2 = Utils.isConstraintForStereotype((Constraint)constraint);
        boolean bl3 = _not_1 = _isConstraintForStereotype_2 == false;
        if (_not_1) {
            boolean _notEquals_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"private boolean evaluateConstraint(EObject self) {");
            _builder.newLine();
            ValueSpecification _specification_2 = constraint.getSpecification();
            String _javaConstraintBody_2 = Utils.getJavaConstraintBody((ValueSpecification)_specification_2);
            boolean bl4 = _notEquals_1 = !Objects.equal((Object)_javaConstraintBody_2, null);
            if (_notEquals_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                ValueSpecification _specification_3 = constraint.getSpecification();
                String _javaConstraintBody_3 = Utils.getJavaConstraintBody((ValueSpecification)_specification_3);
                _builder.append((Object)_javaConstraintBody_3, "\t\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return true;");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public static void generate(Resource input, IPFileSystemAccess fsa) {
        TreeIterator _allContents = input.getAllContents();
        UnmodifiableIterator contentIterator = Iterators.filter((Iterator)_allContents, Constraint.class);
        while (contentIterator.hasNext()) {
            Constraint constraint = (Constraint)contentIterator.next();
            Boolean _hasSpecificationForJava = Utils.hasSpecificationForJava((Constraint)constraint);
            if (!_hasSpecificationForJava.booleanValue()) continue;
            String _name = constraint.getName();
            boolean _equals = Objects.equal((Object)_name, null);
            if (_equals) {
                Namespace _context = constraint.getContext();
                String _qualifiedName = _context.getQualifiedName();
                String _plus = "Constraint has no name, context: " + _qualifiedName;
                throw new RuntimeException(_plus);
            }
            String _topPkg = Utils.getTopPkg();
            String _replaceAll = _topPkg.replaceAll("\\.", "/");
            String _plus_1 = String.valueOf(_replaceAll) + "/constraints/";
            String _name_1 = constraint.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String fileName = String.valueOf(_plus_2) + "Constraint.java";
            CharSequence _generateConstraint = ConstraintGen.generateConstraint(constraint);
            String _string = _generateConstraint.toString();
            fsa.generateFile(fileName, _string);
        }
    }
}

