/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.generator.xtend;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;
import org.eclipse.papyrus.codegen.base.ProjectBasedFileAccess;
import org.eclipse.papyrus.dsml.validation.generator.xtend.ClientSelectorGen;
import org.eclipse.papyrus.dsml.validation.generator.xtend.ConstraintGen;

public class Generate {
    public static final String SRC = "src-gen";

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Arguments not valid : {model, folder}.");
        } else {
            URI modelURI = URI.createFileURI((String)args[0]);
            File folder = new File(args[1]);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(modelURI);
        }
    }

    protected static void createSourceFolder(IProject targetProject, String sourceFolder) {
        IFolder folder = targetProject.getFolder(sourceFolder);
        if (!folder.exists()) {
            try {
                folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)targetProject);
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IPath srcPath = javaProject.getPath().append(sourceFolder);
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getPath().equals((Object)srcPath)) {
                    return;
                }
                ++n2;
            }
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcPath, null);
            newEntries[entries.length] = JavaCore.newSourceEntry((IPath)srcEntry.getPath());
            javaProject.setRawClasspath(newEntries, null);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    public static void generateClientSelector(Resource input, IProject targetProject, IProgressMonitor monitor) throws IOException {
        Generate.createSourceFolder(targetProject, SRC);
        ProjectBasedFileAccess fsa = new ProjectBasedFileAccess(targetProject, SRC);
        ClientSelectorGen.generate(input, (IPFileSystemAccess)fsa);
    }

    public static void generateConstraints(Resource input, IProject targetProject, IProgressMonitor monitor) throws IOException {
        Generate.createSourceFolder(targetProject, SRC);
        ProjectBasedFileAccess fsa = new ProjectBasedFileAccess(targetProject, SRC);
        ConstraintGen.generate(input, (IPFileSystemAccess)fsa);
    }
}

