/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.customization.plugin.PluginEditor;
import org.eclipse.papyrus.dsml.validation.PapyrusDSMLValidationRule.MessageHandling;
import org.eclipse.papyrus.dsml.validation.PapyrusDSMLValidationRule.NameBasedMsgMode;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.ValidationRuleImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Category;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintProvider;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsCategory;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsManager;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IValidationRule;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ValidationPluginGenerator {
    private static final String CONSTRAINT_S_IS_VIOLATED = "Constraint '%s' is violated";
    private static final String XML_CONSTRAINT_TARGET = "target";
    private static final String XML_CONSTRAINT_MESSAGE = "message";
    private static final String XML_CONSTRAINT_CLASS = "class";
    private static final String XML_CONSTRAINT_IS_ENABLED_BY_DEFAULT = "isEnabledByDefault";
    private static final String JAVA_LANGUAGE = "Java";
    private static final String OCL_LANGUAGE = "OCLpivot";
    private static final String XML_CONSTRAINT_MODE = "mode";
    private static final String XML_CONSTRAINT_SEVERITY = "severity";
    private static final String XML_CONSTRAINT_STATUS_CODE = "statusCode";
    private static final String XML_CONSTRAINT_LANG = "lang";
    private static final String XML_CONSTRAINT_NAME = "name";
    private static final String SEPARATOR = ".";
    private static final String EMF_VALIDATION_CONSTRAINT_CHILD = "constraint";
    private static final String ATTRIB_ID = "id";
    private static final String ATTRIB_NAME = "name";
    private static final String EMF_VALIDATION_CONSTRAINT_PROVIDERS_EXTENSIONPOINT = "org.eclipse.emf.validation.constraintProviders";
    private static final String EMF_VALIDATION_CONSTRAINT_BINDINGS_EXTENSIONPOINT = "org.eclipse.emf.validation.constraintBindings";
    private static final String UML_PLUGIN = "org.eclipse.uml2.uml";
    private static final String EMF_VALIDATION_PLUGIN = "org.eclipse.emf.validation";
    private static final String UML_VALIDATION_PLUGIN = "org.eclipse.papyrus.uml.service.validation";
    public static final String UML_DSML_VALIDATION_PROFILE_PLUGIN = "org.eclipse.papyrus.dsml.validation";
    public static ValidationPluginGenerator instance = new ValidationPluginGenerator();
    private static final String PLUGIN_NATURE_ID = "org.eclipse.pde.PluginNature";
    private IConstraintsManager constraintsManager;

    public boolean addDependency(IProject project, String pluginName) throws CoreException, IOException {
        if (project != null && project.exists() && !pluginName.equals(project.getName())) {
            ManifestEditor manifest = new ManifestEditor(project);
            manifest.init();
            if (manifest.initOk() && !manifest.hasDependency(pluginName)) {
                manifest.addDependency(pluginName);
                manifest.save();
                return true;
            }
        }
        return false;
    }

    public void generate(IProject project, IConstraintsManager constraintsManager, EPackage definition) throws CoreException, IOException, SAXException, ParserConfigurationException {
        this.constraintsManager = constraintsManager;
        PluginEditor editor = new PluginEditor(project);
        editor.registerSourceFolder("src-gen");
        String pluginID = editor.getSymbolicBundleName();
        if (editor.getBundleName() == null) {
            editor.setBundleName(pluginID);
        }
        editor.setSingleton(true);
        editor.getBuildEditor().addToBuild("plugin.xml");
        HashSet<String> natures = new HashSet<String>();
        natures.add(PLUGIN_NATURE_ID);
        editor.addNatures(natures);
        editor.getManifestEditor().addDependency(EMF_VALIDATION_PLUGIN);
        editor.getManifestEditor().addDependency(UML_VALIDATION_PLUGIN);
        editor.getManifestEditor().addDependency(UML_PLUGIN);
        String filterName = "dsml.validation.generated." + this.constraintsManager.getPrimeCategory().getID();
        Element constraintProviderExtension = this.createOrCleanExtension(editor, EMF_VALIDATION_CONSTRAINT_PROVIDERS_EXTENSIONPOINT, filterName);
        this.createExtensionForCategory(pluginID, this.constraintsManager.getPrimeCategory(), constraintProviderExtension, editor);
        for (IConstraintProvider constraintProvider : constraintsManager.getConstraintsProviders()) {
            Element extElForConstraintsProvider = this.createExtensionForConstraintsProvider(constraintProvider, constraintProviderExtension, editor, definition);
            for (IConstraintsCategory constraintCategory : constraintProvider.getConstraintsCategories()) {
                Element extElForConstraintsCategory = this.createExtensionForConstraintsCategory(pluginID, constraintCategory, extElForConstraintsProvider, editor, constraintsManager);
                for (IValidationRule constraint : constraintCategory.getConstraints()) {
                    if (Utils.hasSpecificationForJava((Constraint)constraint.getConstraint()).booleanValue()) {
                        this.createJavaExtensionForConstraint(pluginID, constraint, extElForConstraintsCategory, editor);
                    }
                    if (!Utils.hasSpecificationForOCL((Constraint)constraint.getConstraint()).booleanValue()) continue;
                    this.createOCLExtensionForConstraint(constraint, extElForConstraintsCategory, editor);
                }
            }
        }
        this.generateBindings(pluginID, editor, this.constraintsManager, filterName);
        try {
            editor.save();
            editor.getProject().refreshLocal(0, null);
        }
        finally {
            return;
        }
    }

    private Element createExtensionForConstraint(IValidationRule validationRule, Element parentElement, PluginEditor editor) {
        Element extElForConstraint = editor.getPluginEditor().addChild(parentElement, EMF_VALIDATION_CONSTRAINT_CHILD);
        extElForConstraint.setAttribute(ATTRIB_ID, validationRule.getID());
        extElForConstraint.setAttribute("name", validationRule.getName());
        extElForConstraint.setAttribute(XML_CONSTRAINT_STATUS_CODE, validationRule.getStatusCode().toString());
        extElForConstraint.setAttribute(XML_CONSTRAINT_SEVERITY, validationRule.getSeverity().name());
        extElForConstraint.setAttribute(XML_CONSTRAINT_MODE, validationRule.getMode().name());
        extElForConstraint.setAttribute(XML_CONSTRAINT_IS_ENABLED_BY_DEFAULT, String.valueOf(validationRule.isEnabledByDefault()));
        if (validationRule.getTargets() != null) {
            for (String target : validationRule.getTargets()) {
                Element targetExtension = editor.addChild(extElForConstraint, XML_CONSTRAINT_TARGET);
                targetExtension.setAttribute(XML_CONSTRAINT_CLASS, target);
            }
        }
        String validationMsg = validationRule.getMessage();
        Element message = editor.addChild(extElForConstraint, XML_CONSTRAINT_MESSAGE);
        if (validationMsg != null && validationMsg.length() > 0) {
            message.setTextContent(validationMsg);
        } else {
            MessageHandling messageHandling;
            Package constraintPkg = validationRule.getConstraint().getNearestPackage();
            boolean set = false;
            if (constraintPkg != null && (messageHandling = (MessageHandling)UMLUtil.getStereotypeApplication((org.eclipse.uml2.uml.Element)constraintPkg, MessageHandling.class)) != null) {
                String template;
                if (messageHandling.getMessageMode() == NameBasedMsgMode.NAME_IS_MESSAGE) {
                    message.setTextContent(validationRule.getName());
                    set = true;
                } else if (messageHandling.getMessageMode() == NameBasedMsgMode.CUSTOM_TEMPLATE && (template = messageHandling.getCustomTemplate()) != null && template.length() > 0) {
                    message.setTextContent(String.format(template, validationRule.getName()));
                    set = true;
                }
            }
            if (!set) {
                message.setTextContent(String.format(CONSTRAINT_S_IS_VIOLATED, validationRule.getName()));
            }
        }
        if (validationRule.getDescription() != null) {
            Element description = editor.addChild(extElForConstraint, "description");
            description.setTextContent(validationRule.getDescription());
        }
        return extElForConstraint;
    }

    private Element createJavaExtensionForConstraint(String pluginID, IValidationRule validationRule, Element parentElement, PluginEditor editor) {
        Element extElForConstraint = this.createExtensionForConstraint(validationRule, parentElement, editor);
        extElForConstraint.setAttribute(XML_CONSTRAINT_LANG, JAVA_LANGUAGE);
        extElForConstraint.setAttribute(XML_CONSTRAINT_CLASS, String.valueOf(pluginID) + SEPARATOR + validationRule.getImplementingClass());
        return extElForConstraint;
    }

    private Element createOCLExtensionForConstraint(IValidationRule validationRule, Element parentElement, PluginEditor editor) {
        Element extElForConstraint = this.createExtensionForConstraint(validationRule, parentElement, editor);
        extElForConstraint.setAttribute(XML_CONSTRAINT_LANG, OCL_LANGUAGE);
        extElForConstraint.setAttribute(XML_CONSTRAINT_STATUS_CODE, validationRule.getStatusCode().toString());
        extElForConstraint.setAttribute(XML_CONSTRAINT_SEVERITY, validationRule.getSeverity().name());
        if (Utils.getOCLConstraintBody((Constraint)validationRule.getConstraint()) != null) {
            Document doc = editor.getDocument();
            CDATASection cdata = doc.createCDATASection(Utils.getOCLConstraintBody((Constraint)validationRule.getConstraint()));
            extElForConstraint.appendChild(cdata);
        }
        return extElForConstraint;
    }

    public static Document parseXmlFile(String filename, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            Document doc = factory.newDocumentBuilder().parse(new File(filename));
            return doc;
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Element createExtensionForCategory(String pluginID, Category category, Element parentElement, PluginEditor editor) {
        Element extElForCategory = editor.getPluginEditor().addChild(parentElement, "category");
        extElForCategory.setAttribute(ATTRIB_ID, String.valueOf(pluginID) + SEPARATOR + category.getID());
        extElForCategory.setAttribute("name", String.valueOf(pluginID) + SEPARATOR + category.getName());
        extElForCategory.setAttribute("mandatory", String.valueOf(category.isMandatory()));
        return extElForCategory;
    }

    private Element createExtensionForConstraintsProvider(IConstraintProvider constraintProvider, Element parentElement, PluginEditor editor, EPackage definition) {
        Element extElForConstraintsProvider = editor.getPluginEditor().addChild(parentElement, "constraintProvider");
        extElForConstraintsProvider.setAttribute(XML_CONSTRAINT_MODE, constraintProvider.getMode().name());
        extElForConstraintsProvider.setAttribute("cache", String.valueOf(constraintProvider.getCache()));
        Element pcg = editor.addChild(extElForConstraintsProvider, "package");
        if (constraintProvider.getEPackage() == null) {
            pcg.setAttribute("namespaceUri", "http://www.eclipse.org/uml2/5.0.0/UML");
        } else {
            pcg.setAttribute("namespaceUri", constraintProvider.getEPackage().getNsURI());
        }
        return extElForConstraintsProvider;
    }

    private Element createExtensionForConstraintsCategory(String pluginID, IConstraintsCategory constraintsCategory, Element parentElement, PluginEditor editor, IConstraintsManager constraintManager) {
        Element extElForConstraintsCategory = editor.getPluginEditor().addChild(parentElement, "constraints");
        extElForConstraintsCategory.setAttribute("categories", String.valueOf(pluginID) + SEPARATOR + constraintManager.getPrimeCategory().getName());
        return extElForConstraintsCategory;
    }

    private void generateBindings(String pluginID, PluginEditor editor, IConstraintsManager constraintsManager, String filterName) {
        Element extension = this.createOrCleanExtension(editor, EMF_VALIDATION_CONSTRAINT_BINDINGS_EXTENSIONPOINT, filterName);
        Set constrainedStereotype = constraintsManager.getConstraintsOfStereotype().keySet();
        for (Stereotype stereotype : constrainedStereotype) {
            Element clientContextElement = editor.getPluginEditor().addChild(extension, "clientContext");
            clientContextElement.setAttribute(ATTRIB_ID, String.valueOf(stereotype.getName()) + "ClientContext");
            Element selectorElement = editor.addChild(clientContextElement, "selector");
            selectorElement.setAttribute(XML_CONSTRAINT_CLASS, String.valueOf(pluginID) + ".selectors." + stereotype.getName() + "ClientSelector");
            List constraints = (List)constraintsManager.getConstraintsOfStereotype().get(stereotype);
            Element bindingelement = editor.getPluginEditor().addChild(extension, "binding");
            bindingelement.setAttribute("context", String.valueOf(stereotype.getName()) + "ClientContext");
            for (Constraint constraint : constraints) {
                ((ValidationRuleImpl)constraintsManager.getValidationRuleMap().get(constraint)).getID();
                Element constraintElement = editor.addChild(bindingelement, EMF_VALIDATION_CONSTRAINT_CHILD);
                constraintElement.setAttribute("ref", String.valueOf(pluginID) + SEPARATOR + ((ValidationRuleImpl)constraintsManager.getValidationRuleMap().get(constraint)).getID());
            }
        }
    }

    protected Element createOrCleanExtension(PluginEditor editor, String extensionName, String filterName) {
        List existingExtensions = editor.getPluginEditor().getExtensions(extensionName);
        for (Node extension : existingExtensions) {
            Node child;
            if (!(extension instanceof Element)) continue;
            Element extensionElement = (Element)extension;
            String name = extensionElement.getAttribute("name");
            if (name.equals("")) {
                extensionElement.setAttribute("name", filterName);
                name = filterName;
            }
            if (!name.equals(filterName)) continue;
            while ((child = extension.getFirstChild()) != null) {
                extension.removeChild(child);
            }
            return extensionElement;
        }
        Element newExtension = editor.getPluginEditor().addExtension(extensionName);
        newExtension.setAttribute("name", filterName);
        return newExtension;
    }

    public static String getContextprefix() {
        return "";
    }
}

