/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.behavior;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FunctionBehaviorKind implements Enumerator
{
    ASCET(0, "ASCET", "ASCET"),
    OTHER(1, "OTHER", "OTHER"),
    SCADE(2, "SCADE", "SCADE"),
    SDL(3, "SDL", "SDL"),
    SIMULINK(4, "SIMULINK", "SIMULINK"),
    STATEMATE(5, "STATEMATE", "STATEMATE"),
    MARTE(6, "MARTE", "MARTE"),
    UML(7, "UML", "UML"),
    SCILAB(8, "SCILAB", "SCILAB");

    public static final int ASCET_VALUE = 0;
    public static final int OTHER_VALUE = 1;
    public static final int SCADE_VALUE = 2;
    public static final int SDL_VALUE = 3;
    public static final int SIMULINK_VALUE = 4;
    public static final int STATEMATE_VALUE = 5;
    public static final int MARTE_VALUE = 6;
    public static final int UML_VALUE = 7;
    public static final int SCILAB_VALUE = 8;
    private static final FunctionBehaviorKind[] VALUES_ARRAY;
    public static final List<FunctionBehaviorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FunctionBehaviorKind[]{ASCET, OTHER, SCADE, SDL, SIMULINK, STATEMATE, MARTE, UML, SCILAB};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FunctionBehaviorKind get(int value) {
        switch (value) {
            case 0: {
                return ASCET;
            }
            case 1: {
                return OTHER;
            }
            case 2: {
                return SCADE;
            }
            case 3: {
                return SDL;
            }
            case 4: {
                return SIMULINK;
            }
            case 5: {
                return STATEMATE;
            }
            case 6: {
                return MARTE;
            }
            case 7: {
                return UML;
            }
            case 8: {
                return SCILAB;
            }
        }
        return null;
    }

    public static FunctionBehaviorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionBehaviorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FunctionBehaviorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionBehaviorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private FunctionBehaviorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

