/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.behavior;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TriggerPolicyKind implements Enumerator
{
    EVENT(0, "EVENT", "EVENT"),
    TIME(1, "TIME", "TIME");

    public static final int EVENT_VALUE = 0;
    public static final int TIME_VALUE = 1;
    private static final TriggerPolicyKind[] VALUES_ARRAY;
    public static final List<TriggerPolicyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TriggerPolicyKind[]{EVENT, TIME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TriggerPolicyKind get(int value) {
        switch (value) {
            case 0: {
                return EVENT;
            }
            case 1: {
                return TIME;
            }
        }
        return null;
    }

    public static TriggerPolicyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerPolicyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TriggerPolicyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerPolicyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private TriggerPolicyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

