/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.dependability;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExposureClassKind implements Enumerator
{
    E1(0, "E1", "E1"),
    E2(1, "E2", "E2"),
    E3(2, "E3", "E3"),
    E4(3, "E4", "E4");

    public static final int E1_VALUE = 0;
    public static final int E2_VALUE = 1;
    public static final int E3_VALUE = 2;
    public static final int E4_VALUE = 3;
    private static final ExposureClassKind[] VALUES_ARRAY;
    public static final List<ExposureClassKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExposureClassKind[]{E1, E2, E3, E4};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExposureClassKind get(int value) {
        switch (value) {
            case 0: {
                return E1;
            }
            case 1: {
                return E2;
            }
            case 2: {
                return E3;
            }
            case 3: {
                return E4;
            }
        }
        return null;
    }

    public static ExposureClassKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExposureClassKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExposureClassKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExposureClassKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ExposureClassKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

