/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.structure.featuremodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingTimeKind implements Enumerator
{
    SYSTEM_DESIGN_TIME(0, "systemDesignTime", "systemDesignTime"),
    CODE_GENERATION_TIME(1, "codeGenerationTime", "codeGenerationTime"),
    PRECOMPILE_TIME(2, "precompileTime", "precompileTime"),
    LINK_TIME(3, "linkTime", "linkTime"),
    POST_BUILD(4, "postBuild", "postBuild"),
    RUNTIME(5, "runtime", "runtime");

    public static final int SYSTEM_DESIGN_TIME_VALUE = 0;
    public static final int CODE_GENERATION_TIME_VALUE = 1;
    public static final int PRECOMPILE_TIME_VALUE = 2;
    public static final int LINK_TIME_VALUE = 3;
    public static final int POST_BUILD_VALUE = 4;
    public static final int RUNTIME_VALUE = 5;
    private static final BindingTimeKind[] VALUES_ARRAY;
    public static final List<BindingTimeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingTimeKind[]{SYSTEM_DESIGN_TIME, CODE_GENERATION_TIME, PRECOMPILE_TIME, LINK_TIME, POST_BUILD, RUNTIME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingTimeKind get(int value) {
        switch (value) {
            case 0: {
                return SYSTEM_DESIGN_TIME;
            }
            case 1: {
                return CODE_GENERATION_TIME;
            }
            case 2: {
                return PRECOMPILE_TIME;
            }
            case 3: {
                return LINK_TIME;
            }
            case 4: {
                return POST_BUILD;
            }
            case 5: {
                return RUNTIME;
            }
        }
        return null;
    }

    public static BindingTimeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingTimeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingTimeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingTimeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private BindingTimeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

