/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.structure.functionmodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClientServerKind implements Enumerator
{
    CLIENT(0, "client", "client"),
    SERVER(1, "server", "server");

    public static final int CLIENT_VALUE = 0;
    public static final int SERVER_VALUE = 1;
    private static final ClientServerKind[] VALUES_ARRAY;
    public static final List<ClientServerKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClientServerKind[]{CLIENT, SERVER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClientServerKind get(int value) {
        switch (value) {
            case 0: {
                return CLIENT;
            }
            case 1: {
                return SERVER;
            }
        }
        return null;
    }

    public static ClientServerKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClientServerKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClientServerKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClientServerKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ClientServerKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

