/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.structure.hardwaremodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HardwareBusKind implements Enumerator
{
    TIME_TRIGGERED(0, "TimeTriggered", "TimeTriggered"),
    EVENT_TRIGGERED(1, "EventTriggered", "EventTriggered"),
    TIMEAND_EVENT_TRIGGERED(2, "TimeandEventTriggered", "TimeandEventTriggered"),
    OTHER(3, "other", "other");

    public static final int TIME_TRIGGERED_VALUE = 0;
    public static final int EVENT_TRIGGERED_VALUE = 1;
    public static final int TIMEAND_EVENT_TRIGGERED_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    private static final HardwareBusKind[] VALUES_ARRAY;
    public static final List<HardwareBusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HardwareBusKind[]{TIME_TRIGGERED, EVENT_TRIGGERED, TIMEAND_EVENT_TRIGGERED, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HardwareBusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HardwareBusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HardwareBusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HardwareBusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HardwareBusKind get(int value) {
        switch (value) {
            case 0: {
                return TIME_TRIGGERED;
            }
            case 1: {
                return EVENT_TRIGGERED;
            }
            case 2: {
                return TIMEAND_EVENT_TRIGGERED;
            }
            case 3: {
                return OTHER;
            }
        }
        return null;
    }

    private HardwareBusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

