/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.structure.vehiclefeaturemodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DeviationPermissionKind implements Enumerator
{
    YES(0, "yes", "yes"),
    NO(1, "no", "no"),
    SUBTREE(2, "subtree", "subtree"),
    APPEND(3, "append", "append"),
    SUBSET(4, "subset", "subset"),
    WIDEN(5, "widen", "widen");

    public static final int YES_VALUE = 0;
    public static final int NO_VALUE = 1;
    public static final int SUBTREE_VALUE = 2;
    public static final int APPEND_VALUE = 3;
    public static final int SUBSET_VALUE = 4;
    public static final int WIDEN_VALUE = 5;
    private static final DeviationPermissionKind[] VALUES_ARRAY;
    public static final List<DeviationPermissionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DeviationPermissionKind[]{YES, NO, SUBTREE, APPEND, SUBSET, WIDEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DeviationPermissionKind get(int value) {
        switch (value) {
            case 0: {
                return YES;
            }
            case 1: {
                return NO;
            }
            case 2: {
                return SUBTREE;
            }
            case 3: {
                return APPEND;
            }
            case 4: {
                return SUBSET;
            }
            case 5: {
                return WIDEN;
            }
        }
        return null;
    }

    public static DeviationPermissionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeviationPermissionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DeviationPermissionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeviationPermissionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private DeviationPermissionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

