/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.timing.timingconstraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComparisonKind implements Enumerator
{
    EQUAL(0, "equal", "equal"),
    GREATER_THAN(1, "greaterThan", "greaterThan"),
    GREATER_THAN_OR_EQUAL(2, "greaterThanOrEqual", "greaterThanOrEqual"),
    LESS_THAN(3, "lessThan", "lessThan"),
    LESS_THAN_OR_EQUAL(4, "lessThanOrEqual", "lessThanOrEqual");

    public static final int EQUAL_VALUE = 0;
    public static final int GREATER_THAN_VALUE = 1;
    public static final int GREATER_THAN_OR_EQUAL_VALUE = 2;
    public static final int LESS_THAN_VALUE = 3;
    public static final int LESS_THAN_OR_EQUAL_VALUE = 4;
    private static final ComparisonKind[] VALUES_ARRAY;
    public static final List<ComparisonKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComparisonKind[]{EQUAL, GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN, LESS_THAN_OR_EQUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComparisonKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparisonKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparisonKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparisonKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparisonKind get(int value) {
        switch (value) {
            case 0: {
                return EQUAL;
            }
            case 1: {
                return GREATER_THAN;
            }
            case 2: {
                return GREATER_THAN_OR_EQUAL;
            }
            case 3: {
                return LESS_THAN;
            }
            case 4: {
                return LESS_THAN_OR_EQUAL;
            }
        }
        return null;
    }

    private ComparisonKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

