/**
 * Copyright (c) 2013 CEA LIST
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ansgar Radermacher - Initial API and implementation
 *
 */
package org.eclipse.papyrus.FCM.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.FCM.Connector;
import org.eclipse.papyrus.FCM.FCMPackage;
import org.eclipse.papyrus.FCM.InteractionComponent;
import org.eclipse.uml2.uml.Property;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Connector</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.FCM.impl.ConnectorImpl#getBase_Connector <em>Base Connector</em>}</li>
 * <li>{@link org.eclipse.papyrus.FCM.impl.ConnectorImpl#getIc <em>Ic</em>}</li>
 * <li>{@link org.eclipse.papyrus.FCM.impl.ConnectorImpl#getBase_Property <em>Base Property</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConnectorImpl extends ConfigurableElementInstanceImpl implements Connector {
	/**
	 * The cached value of the '{@link #getBase_Connector() <em>Base Connector</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getBase_Connector()
	 * @generated
	 * @ordered
	 */
	protected org.eclipse.uml2.uml.Connector base_Connector;

	/**
	 * The cached value of the '{@link #getIc() <em>Ic</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getIc()
	 * @generated
	 * @ordered
	 */
	protected InteractionComponent ic;

	/**
	 * The cached value of the '{@link #getBase_Property() <em>Base Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getBase_Property()
	 * @generated
	 * @ordered
	 */
	protected Property base_Property;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ConnectorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return FCMPackage.Literals.CONNECTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public org.eclipse.uml2.uml.Connector getBase_Connector() {
		if (base_Connector != null && base_Connector.eIsProxy()) {
			InternalEObject oldBase_Connector = (InternalEObject) base_Connector;
			base_Connector = (org.eclipse.uml2.uml.Connector) eResolveProxy(oldBase_Connector);
			if (base_Connector != oldBase_Connector) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, FCMPackage.CONNECTOR__BASE_CONNECTOR, oldBase_Connector, base_Connector));
				}
			}
		}
		return base_Connector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public org.eclipse.uml2.uml.Connector basicGetBase_Connector() {
		return base_Connector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setBase_Connector(org.eclipse.uml2.uml.Connector newBase_Connector) {
		org.eclipse.uml2.uml.Connector oldBase_Connector = base_Connector;
		base_Connector = newBase_Connector;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FCMPackage.CONNECTOR__BASE_CONNECTOR, oldBase_Connector, base_Connector));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public InteractionComponent getIc() {
		if (ic != null && ic.eIsProxy()) {
			InternalEObject oldIc = (InternalEObject) ic;
			ic = (InteractionComponent) eResolveProxy(oldIc);
			if (ic != oldIc) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, FCMPackage.CONNECTOR__IC, oldIc, ic));
				}
			}
		}
		return ic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public InteractionComponent basicGetIc() {
		return ic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setIc(InteractionComponent newIc) {
		InteractionComponent oldIc = ic;
		ic = newIc;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FCMPackage.CONNECTOR__IC, oldIc, ic));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Property getBase_Property() {
		if (base_Property != null && base_Property.eIsProxy()) {
			InternalEObject oldBase_Property = (InternalEObject) base_Property;
			base_Property = (Property) eResolveProxy(oldBase_Property);
			if (base_Property != oldBase_Property) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, FCMPackage.CONNECTOR__BASE_PROPERTY, oldBase_Property, base_Property));
				}
			}
		}
		return base_Property;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public Property basicGetBase_Property() {
		return base_Property;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setBase_Property(Property newBase_Property) {
		Property oldBase_Property = base_Property;
		base_Property = newBase_Property;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FCMPackage.CONNECTOR__BASE_PROPERTY, oldBase_Property, base_Property));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case FCMPackage.CONNECTOR__BASE_CONNECTOR:
			if (resolve) {
				return getBase_Connector();
			}
			return basicGetBase_Connector();
		case FCMPackage.CONNECTOR__IC:
			if (resolve) {
				return getIc();
			}
			return basicGetIc();
		case FCMPackage.CONNECTOR__BASE_PROPERTY:
			if (resolve) {
				return getBase_Property();
			}
			return basicGetBase_Property();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case FCMPackage.CONNECTOR__BASE_CONNECTOR:
			setBase_Connector((org.eclipse.uml2.uml.Connector) newValue);
			return;
		case FCMPackage.CONNECTOR__IC:
			setIc((InteractionComponent) newValue);
			return;
		case FCMPackage.CONNECTOR__BASE_PROPERTY:
			setBase_Property((Property) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case FCMPackage.CONNECTOR__BASE_CONNECTOR:
			setBase_Connector((org.eclipse.uml2.uml.Connector) null);
			return;
		case FCMPackage.CONNECTOR__IC:
			setIc((InteractionComponent) null);
			return;
		case FCMPackage.CONNECTOR__BASE_PROPERTY:
			setBase_Property((Property) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case FCMPackage.CONNECTOR__BASE_CONNECTOR:
			return base_Connector != null;
		case FCMPackage.CONNECTOR__IC:
			return ic != null;
		case FCMPackage.CONNECTOR__BASE_PROPERTY:
			return base_Property != null;
		}
		return super.eIsSet(featureID);
	}

} // ConnectorImpl
