/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.FCM.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.FCM.DerivedElement;
import org.eclipse.papyrus.FCM.Port;
import org.eclipse.papyrus.FCM.PortKind;
import org.eclipse.papyrus.FCM.TemplatePort;
import org.eclipse.papyrus.FCM.util.IMappingRule;
import org.eclipse.papyrus.FCM.util.ITemplateMappingRule;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class MapUtil {
    public static final String rootModelName = "root";
    public static final String MAPPING_RULE_ID = "fcmPortMappingRule";

    public static Package getTop(Element element) {
        while (element != null) {
            Element owner = element.getOwner();
            if (owner == null) {
                if (element instanceof Package) {
                    return (Package)element;
                }
            } else if (owner instanceof Package && owner.getOwner() == null && ((Package)owner).getName().equals(rootModelName)) {
                boolean cfr_ignored_0 = element instanceof Package;
            }
            element = owner;
        }
        return null;
    }

    public static DerivedElement applyDE(Element element) {
        Stereotype stereotype = element.getApplicableStereotype("FCM::DerivedElement");
        if (stereotype != null) {
            EObject alreadyApplied = element.getStereotypeApplication(stereotype);
            if (alreadyApplied instanceof DerivedElement) {
                return (DerivedElement)alreadyApplied;
            }
            alreadyApplied = element.applyStereotype(stereotype);
            if (alreadyApplied instanceof DerivedElement) {
                return (DerivedElement)alreadyApplied;
            }
        }
        return null;
    }

    public static Package getAndCreate(Package root, String name, boolean createOnDemand) {
        NamedElement pkg = root.getOwnedMember(name);
        if (pkg == null && createOnDemand) {
            pkg = root.createNestedPackage(name);
        }
        return (Package)pkg;
    }

    public static Interface getOrCreateDerivedInterface(Port port, String separation, Type type) {
        return MapUtil.getOrCreateDerivedInterface(port, separation, type, false);
    }

    public static Interface getDerivedInterface(Port port, String separation, Type type) {
        return MapUtil.getOrCreateDerivedInterface(port, separation, type, true);
    }

    public static Interface getOrCreateDerivedInterface(Port port, String separation, Type type, boolean createOnDemand) {
        if (port == null) {
            return null;
        }
        PortKind kind = port.getKind();
        if (kind == null) {
            return null;
        }
        return MapUtil.getOrCreateDerivedInterfaceIntern(port, String.valueOf(kind.getBase_Class().getName()) + separation, type, createOnDemand);
    }

    public static Interface getOrCreateDerivedInterfaceFP(Port port, String prefix, Type type) {
        return MapUtil.getOrCreateDerivedInterfaceIntern(port, prefix, type, false);
    }

    public static Interface getOrCreateDerivedInterfaceFP(Port port, String prefix, Type type, boolean createOnDemand) {
        return MapUtil.getOrCreateDerivedInterfaceIntern(port, prefix, type, createOnDemand);
    }

    public static Interface getDerivedInterfaceFP(Port port, String prefix, Type type) {
        return MapUtil.getOrCreateDerivedInterfaceIntern(port, prefix, type, true);
    }

    public static Package getAndCreate(Package root, EList<Namespace> list, boolean createOnDemand) {
        boolean first = true;
        int i = list.size() - 1;
        while (i >= 0) {
            block6: {
                NamedElement pkg;
                Namespace ns;
                block5: {
                    ns = (Namespace)list.get(i);
                    if (!first) break block5;
                    first = false;
                    if (ns.getName().equals(rootModelName)) break block6;
                }
                if ((pkg = root.getOwnedMember(ns.getName())) == null && createOnDemand) {
                    pkg = root.createNestedPackage(ns.getName());
                }
                if (!(pkg instanceof Package)) break;
                root = (Package)pkg;
            }
            --i;
        }
        return root;
    }

    private static Interface getOrCreateDerivedInterfaceIntern(Port port, String prefix, Type type, boolean createOnDemand) {
        PackageableElement pe;
        PackageableElement portKinds;
        String interfaceName = "D_" + prefix + type.getName();
        Package baseModelOfPort = MapUtil.getTop((Element)port.getBase_Port());
        Package derivedInterfaces = MapUtil.getAndCreate(baseModelOfPort, "derivedInterfaces", createOnDemand);
        if (derivedInterfaces != null) {
            Package owner = MapUtil.getAndCreate(derivedInterfaces, (EList<Namespace>)type.allNamespaces(), createOnDemand);
            Interface intf = null;
            PackageableElement pe2 = owner.getPackagedElement(interfaceName);
            if (pe2 instanceof Interface) {
                return (Interface)pe2;
            }
            if (createOnDemand) {
                intf = owner.createOwnedInterface(interfaceName);
                DerivedElement de = MapUtil.applyDE((Element)intf);
                if (de != null) {
                    de.setSource((Element)type);
                }
                return intf;
            }
        }
        if ((portKinds = baseModelOfPort.getImportedMember("PortKinds")) instanceof Package && (pe = ((Package)portKinds).getPackagedElement("Please update derived elements")) instanceof Interface) {
            return (Interface)pe;
        }
        return null;
    }

    public static Interface getProvidedInterface(Port port) {
        String ruleName;
        IMappingRule mappingRule;
        if (port.getBase_Port() == null) {
            return null;
        }
        PortKind portKind = port.getKind();
        if (portKind == null) {
            if (port.getBase_Port().getProvideds().size() > 0) {
                return (Interface)port.getBase_Port().getProvideds().get(0);
            }
        } else if (portKind.getBase_Class() != null && (mappingRule = MapUtil.getMappingRule(ruleName = portKind.isExtendedPort() ? "ExtendedPort" : portKind.getBase_Class().getName())) != null) {
            return mappingRule.getProvided(port, false);
        }
        return null;
    }

    public static Interface getRequiredInterface(Port port) {
        String ruleName;
        IMappingRule mappingRule;
        PortKind portKind = port.getKind();
        if (port.getBase_Port() == null) {
            return null;
        }
        if (portKind == null) {
            if (port.getBase_Port().getRequireds().size() > 0) {
                return (Interface)port.getBase_Port().getRequireds().get(0);
            }
        } else if (portKind.getBase_Class() != null && (mappingRule = MapUtil.getMappingRule(ruleName = portKind.isExtendedPort() ? "ExtendedPort" : portKind.getBase_Class().getName())) != null) {
            return mappingRule.getRequired(port, false);
        }
        return null;
    }

    public static IMappingRule getMappingRule(String portKindName) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor("org.eclipse.papyrus.fcm.profile.fcmPortMappingRule");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String extPortKindName = configElement.getAttribute("portKindName");
                if (extPortKindName.equals(portKindName) && (obj = configElement.createExecutableExtension("class")) instanceof IMappingRule) {
                    return (IMappingRule)obj;
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return null;
    }

    public static IMappingRule getMappingRule(Port port) {
        if (port.getBase_Port() == null) {
            return null;
        }
        PortKind portKind = port.getKind();
        if (portKind == null) {
            return null;
        }
        if (portKind.getBase_Class() != null) {
            String ruleName;
            String string = ruleName = portKind.isExtendedPort() ? "ExtendedPort" : portKind.getBase_Class().getName();
            if (port instanceof TemplatePort) {
                ruleName = "TemplatePort";
            }
            return MapUtil.getMappingRule(ruleName);
        }
        return null;
    }

    public static PortKind getBoundType(Port port) {
        if (port.getBase_Port() == null) {
            return null;
        }
        String ruleName = "TemplatePort";
        IMappingRule mappingRule = MapUtil.getMappingRule(ruleName);
        if (mappingRule instanceof ITemplateMappingRule) {
            return ((ITemplateMappingRule)mappingRule).getBoundType(port);
        }
        return null;
    }

    public static void update(Port port) {
        IMappingRule mappingRule = MapUtil.getMappingRule(port);
        if (mappingRule != null) {
            mappingRule.getProvided(port, true);
            mappingRule.getRequired(port, true);
            if (mappingRule instanceof ITemplateMappingRule) {
                ((ITemplateMappingRule)mappingRule).updateBinding(port);
            }
        }
    }

    public static boolean needsUpdate(Port port) {
        IMappingRule mappingRule = MapUtil.getMappingRule(port);
        if (mappingRule != null) {
            return mappingRule.needsUpdate(port);
        }
        return false;
    }
}

