/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.tracepoints.commands;

import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.services.tracepoints.Activator;
import org.eclipse.papyrus.infra.services.tracepoints.ITraceMechanism;
import org.eclipse.papyrus.infra.services.tracepoints.TraceMechanism;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.State;

public abstract class AbstractTracepointCommand
extends AbstractTransactionalCommand {
    protected TransactionalEditingDomain domain;
    protected EObject selectedElement;
    protected Resource resource;
    protected IResource iresource;
    protected String uri;

    public AbstractTracepointCommand(String label, TransactionalEditingDomain domain, EObject selectedElement) {
        super(domain, label, Collections.EMPTY_LIST);
        this.domain = domain;
        this.selectedElement = selectedElement;
    }

    protected void updateResourceAndURI() {
        this.resource = this.selectedElement.eResource();
        this.uri = this.resource.getURI() + "#" + this.resource.getURIFragment(this.selectedElement);
        this.iresource = WorkspaceSynchronizer.getFile((Resource)this.selectedElement.eResource());
    }

    protected IMarker findMarker(String type) {
        if (this.iresource != null) {
            try {
                IMarker[] iMarkerArray = this.iresource.findMarkers(type, false, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String markerURI = marker.getAttribute("uri", "");
                    if (markerURI != null && markerURI.equals(this.uri)) {
                        return marker;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected IMarker toggleMarker() {
        try {
            if (this.iresource != null) {
                IMarker marker = this.findMarker("org.eclipse.papyrus.tporbpmarker");
                if (marker == null) {
                    marker = this.iresource.createMarker("org.eclipse.papyrus.tporbpmarker");
                    marker.setAttribute("uri", (Object)this.uri);
                    marker.setAttribute("isActive", true);
                    return marker;
                }
                marker.delete();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    protected void toggleMarkerActivation() {
        try {
            if (this.iresource != null) {
                IMarker marker = this.findMarker("org.eclipse.papyrus.tporbpmarker");
                if (marker == null) {
                    marker = this.iresource.createMarker("org.eclipse.papyrus.tporbpmarker");
                    marker.setAttribute("uri", (Object)this.uri);
                    marker.setAttribute("isActive", true);
                    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                    String id = null;
                    if (this.selectedElement instanceof Operation) {
                        id = store.getDefaultString("papyrus.trace.implementation.op");
                    } else if (this.selectedElement instanceof Port) {
                        id = store.getDefaultString("papyrus.trace.implementation.port");
                    } else if (this.selectedElement instanceof State) {
                        id = store.getDefaultString("papyrus.trace.implementation.sm");
                    }
                    if (id != null) {
                        EList<ITraceMechanism> mechanisms = TraceMechanism.getTraceMechanisms();
                        for (ITraceMechanism mechanism : mechanisms) {
                            for (String providedID : mechanism.getTraceMechanismIDs(this.selectedElement)) {
                                if (!id.equals(providedID)) continue;
                                mechanism.applyTraceMechanism(this.selectedElement, id, 0);
                            }
                        }
                    }
                } else {
                    boolean isSet = marker.getAttribute("isActive", false);
                    marker.setAttribute("isActive", !isSet);
                }
            }
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    public boolean canExecute() {
        return this.selectedElement != null;
    }
}

