/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.tracepoints.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.tracepoints.commands.AbstractTracepointCommand;
import org.eclipse.papyrus.infra.services.tracepoints.dialogs.TraceActionSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

public class TracepointPropertiesCommand
extends AbstractTracepointCommand {
    public TracepointPropertiesCommand(EObject selectedElement) {
        super("Tracepoint properties", TransactionUtil.getEditingDomain((EObject)selectedElement), selectedElement);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.updateResourceAndURI();
        this.selectTraceActions();
        return null;
    }

    protected void selectTraceActions() {
        IMarker marker = this.findMarker("org.eclipse.papyrus.tporbpmarker");
        if (marker != null) {
            TraceActionSelection tad = new TraceActionSelection(Display.getDefault().getActiveShell(), marker, (Element)this.selectedElement);
            tad.open();
            if (tad.getReturnCode() == 0) {
                Object[] result = tad.getResult();
                String traceAction = (String)result[0];
                String traceMechanism = (String)result[1];
                try {
                    marker.setAttribute("traceAction", (Object)traceAction);
                    marker.setAttribute("traceMechanism", (Object)traceMechanism);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean canExecute() {
        if (this.selectedElement != null) {
            this.updateResourceAndURI();
            IMarker marker = this.findMarker("org.eclipse.papyrus.tporbpmarker");
            if (marker != null) {
                return marker.getAttribute("isTracepoint", false);
            }
        }
        return false;
    }
}

