/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.tracepoints.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.services.tracepoints.Activator;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCommandHandler
extends AbstractHandler {
    protected abstract Command getCommand();

    protected EObject getSelectedElement() {
        Object businessObject;
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null && (businessObject = BusinessModelResolver.getInstance().getBusinessModel(selection)) instanceof EObject) {
            eObject = (EObject)businessObject;
        }
        return eObject;
    }

    protected List<EObject> getSelectedElements() {
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object current = objectArray[n2];
                if (current instanceof IAdaptable) {
                    selectedEObjects.add((EObject)((IAdaptable)current).getAdapter(EObject.class));
                }
                ++n2;
            }
        } else if (selection != null && selection instanceof IAdaptable) {
            selectedEObjects.add((EObject)((IAdaptable)selection).getAdapter(EObject.class));
        }
        return selectedEObjects;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ServiceUtilsForHandlers util = ServiceUtilsForHandlers.getInstance();
            util.getTransactionalEditingDomain((Object)event).getCommandStack().execute(this.getCommand());
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected error while executing command.", (Throwable)e);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.getCommand().canExecute();
    }

    public boolean isVisible() {
        return this.getCommand().canExecute();
    }
}

