/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.tracepoints.preferences;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.papyrus.infra.services.tracepoints.Activator;
import org.eclipse.papyrus.infra.services.tracepoints.ITraceMechanism;
import org.eclipse.papyrus.infra.services.tracepoints.Messages;
import org.eclipse.papyrus.infra.services.tracepoints.TraceActions;
import org.eclipse.papyrus.infra.services.tracepoints.TraceMechanism;
import org.eclipse.papyrus.infra.services.tracepoints.preferences.BinaryEncodedMChoiceFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TPPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public TPPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.TPPreferencePage_TraceOptions);
    }

    public void createFieldEditors() {
        EList<ITraceMechanism> mechanisms = TraceMechanism.getTraceMechanisms();
        int elements = 0;
        for (ITraceMechanism mechanism : mechanisms) {
            EList<String> mechanismIDs = mechanism.getTraceMechanismIDs(null);
            elements += mechanismIDs.size();
        }
        String[][] mechList = new String[elements][2];
        elements = 0;
        for (ITraceMechanism mechanism : mechanisms) {
            EList<String> mechanismIDs = mechanism.getTraceMechanismIDs(null);
            Iterator iterator = mechanismIDs.iterator();
            while (iterator.hasNext()) {
                String id;
                mechList[elements][1] = id = (String)iterator.next();
                mechList[elements][0] = mechanism.getTraceMechanismDescription(null, id);
                ++elements;
            }
        }
        String[][] taClassOptions = TraceActions.getStringFields(TraceActions.TAClass.values());
        String[][] taStateOptions = TraceActions.getStringFields(TraceActions.TAState.values());
        String[][] taOperationOptions = TraceActions.getStringFields(TraceActions.TAOperation.values());
        this.addField(new BinaryEncodedMChoiceFieldEditor("papyrus.trace.option.class", Messages.TPPreferencePage_ClassOptions, 3, taClassOptions, this.getFieldEditorParent(), true));
        this.addField(new BinaryEncodedMChoiceFieldEditor("papyrus.trace.option.state", Messages.TPPreferencePage_StateOptions, 3, taStateOptions, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("papyrus.trace.option.op", Messages.TPPreferencePage_OperationOptions, 3, taOperationOptions, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new ComboFieldEditor("papyrus.trace.implementation.port", Messages.TPPreferencePage_TMforPorts, mechList, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("papyrus.trace.implementation.op", Messages.TPPreferencePage_TMforOperations, mechList, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("papyrus.trace.implementation.sm", Messages.TPPreferencePage_TMforStateMachines, mechList, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

