/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTJavaModel;
import org.eclipse.papyrus.java.generator.metamodel.jdt.generatoroptionsmm.GeneratoroptionsmmFactory;
import org.eclipse.papyrus.java.generator.metamodel.jdt.generatoroptionsmm.Options;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaModel;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JdtmmPackage;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitor;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class RunGenerator {
    private EList<EObject> inObjects;

    public RunGenerator(String umlFileUrl) throws FileNotFoundException {
        this.inObjects = this.loadUmlModel(umlFileUrl);
    }

    public RunGenerator(EList<EObject> inObjects) {
        this.inObjects = inObjects;
    }

    public void runGeneration(GeneratorPreference preference) throws JDTVisitorException {
        EList<EObject> inOptions = this.createOptionModelFromEclipsePreferences(preference);
        URI scriptUri = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.java.generator.transfo.umltojdt/transforms/uml/uml2jdt2.qvto");
        List<EObject> outObjects = this.runTransformation(scriptUri, this.inObjects, inOptions);
        if (outObjects.size() == 0) {
            throw new JDTVisitorException("No classes or packages produced from the transformation. Nothing is generated.");
        }
        if (outObjects.size() > 1) {
            System.err.println("Warning, JDT modele has more than one root. Found root:");
            for (EObject el : outObjects) {
                System.err.println(((JDTJavaElement)el).getElementName());
            }
            System.err.println("-------");
        }
        if (outObjects.size() > 0) {
            for (EObject o : outObjects) {
                if (!(o instanceof JDTJavaModel)) continue;
                JDTJavaElement proj = (JDTJavaElement)o;
                SynchJDTJavaModel visitor = new SynchJDTJavaModel(preference);
                proj.accept((JDTVisitor)visitor);
            }
        }
    }

    private EList<EObject> createOptionModelFromEclipsePreferences(GeneratorPreference preference) {
        GeneratoroptionsmmFactory optionsFactory = GeneratoroptionsmmFactory.eINSTANCE;
        Options options = optionsFactory.createOptions();
        options.setDefaultSourceFolder(preference.defaultSourceFolderName());
        BasicEList optionsContents = new BasicEList(1);
        optionsContents.add((Object)options);
        return optionsContents;
    }

    private List<EObject> runTransformation(URI scriptUri, EList<EObject> inObjects, EList<EObject> inOptions) {
        EPackageRegistryImpl registry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        JdtmmPackage mm1 = JdtmmPackage.eINSTANCE;
        registry.put((Object)mm1.getNsURI(), (Object)mm1);
        TransformationExecutor t = new TransformationExecutor(scriptUri, (EPackage.Registry)registry);
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        BasicModelExtent input = new BasicModelExtent(inObjects);
        BasicModelExtent inputOptions = new BasicModelExtent(inOptions);
        BasicModelExtent output = new BasicModelExtent();
        ExecutionDiagnostic executionDiagnostic = t.execute((ExecutionContext)executionContext, new ModelExtent[]{input, inputOptions, output});
        System.out.println(executionDiagnostic.getMessage());
        for (Diagnostic d : executionDiagnostic.getChildren()) {
            System.out.println(d.getMessage());
        }
        return output.getContents();
    }

    private EList<EObject> loadUmlModel(String url) throws FileNotFoundException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), URI.createFileURI((String)(String.valueOf(System.getProperty("user.dir")) + "/Model_Libs/UMLPrimitiveTypes.library.uml")));
        File file = new File(url);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + new File(url).getAbsolutePath() + " not found");
        }
        URI fileURI = URI.createFileURI((String)new File(url).getAbsolutePath());
        Resource resource = resourceSet.getResource(fileURI, true);
        return resource.getContents();
    }
}

