/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTType;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchTools;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTCompilationUnit;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTType;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitor;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTCompilationUnit
extends EObjectImpl
implements JDTVisitor {
    private IPackageFragment ipack;
    private GeneratorPreference preference;

    public SynchJDTCompilationUnit(IPackageFragment ipack, GeneratorPreference preference) {
        this.ipack = ipack;
        this.preference = preference;
    }

    public void visit(JDTJavaElement element) throws JDTVisitorException {
        if (!element.isGenerated()) {
            return;
        }
        if (SynchTools.isPrimiveType(element.getElementName()) && !element.getElementName().equals("String")) {
            return;
        }
        JDTCompilationUnit cu = (JDTCompilationUnit)element;
        try {
            ICompilationUnit icu = (ICompilationUnit)SynchTools.searchIJavaElement((IJavaElement[])this.ipack.getCompilationUnits(), (String)(String.valueOf(cu.getElementName()) + ".java"));
            if (icu == null) {
                icu = this.ipack.createCompilationUnit(String.valueOf(cu.getElementName()) + ".java", "", true, null);
                if (!this.ipack.getElementName().equals("")) {
                    icu.createPackageDeclaration(this.ipack.getElementName(), null);
                }
            }
            SynchJDTType visitor = new SynchJDTType(icu, this.preference);
            for (JDTType type : cu.getTypes()) {
                type.accept((JDTVisitor)visitor);
            }
            icu.save(null, true);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
    }
}

