/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTMethod;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchTools;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTField;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.TrueFalseDefault;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTGetterSetter
extends SynchJDTMethod {
    private JDTField field;
    private GeneratorPreference preference;

    public SynchJDTGetterSetter(IType it, GeneratorPreference preference) {
        super(it, preference);
        this.preference = preference;
    }

    @Override
    public void visit(JDTJavaElement element) throws JDTVisitorException {
        this.field = (JDTField)element;
        if (this.field.getType() == null) {
            System.err.println("l31 SunchJDTGetterSetter : field.getType() est null pour " + this.field.getElementName() + " dans " + this.field.getOwner().getElementName());
            return;
        }
        try {
            IMethod imethod;
            String fieldNameCap = this.field.getElementName().replaceFirst(".", String.valueOf(this.field.getElementName().charAt(0)).toUpperCase());
            if (this.field.getGenerateGetter() == TrueFalseDefault.TRUE || this.field.getGenerateGetter() == TrueFalseDefault.DEFAULT && this.preference.generateGetters()) {
                StringBuffer bufferGet = new StringBuffer();
                bufferGet.append("public ");
                if (this.field.isMultiValued()) {
                    bufferGet.append(SynchTools.getMultiValued(this.itype, this.field.getType().getElementName(), this.preference));
                } else {
                    bufferGet.append(this.field.getType().getElementName());
                }
                bufferGet.append(" get" + fieldNameCap + "() {\n " + "\t return " + this.field.getElementName() + "; \n} \n");
                imethod = (IMethod)SynchTools.searchIJavaElement((IJavaElement[])this.itype.getMethods(), (String)("get" + fieldNameCap));
                if (imethod == null) {
                    IMethod methodGet = this.itype.createMethod(bufferGet.toString(), null, true, null);
                    this.createJavaDocFor(methodGet, this.itype.getCompilationUnit(), "Getter of " + this.field.getElementName(), "");
                }
            }
            if (this.field.getGenerateSetter() == TrueFalseDefault.TRUE || this.field.getGenerateSetter() == TrueFalseDefault.DEFAULT && this.preference.generateSetters()) {
                StringBuffer bufferSet = new StringBuffer();
                bufferSet.append("public void set" + fieldNameCap + "(");
                if (this.field.isMultiValued()) {
                    bufferSet.append(SynchTools.getMultiValued(this.itype, this.field.getType().getElementName(), this.preference));
                } else {
                    bufferSet.append(this.field.getType().getElementName());
                }
                bufferSet.append(" " + this.field.getElementName() + ") { \n" + "\t this." + this.field.getElementName() + " = " + this.field.getElementName() + "; \n} \n ");
                imethod = (IMethod)SynchTools.searchIJavaElement((IJavaElement[])this.itype.getMethods(), (String)("set" + fieldNameCap));
                if (imethod == null) {
                    IMethod methodSet = this.itype.createMethod(bufferSet.toString(), null, true, null);
                    this.createJavaDocFor(methodSet, this.itype.getCompilationUnit(), "Setter of " + this.field.getElementName(), "");
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected BodyDeclaration searchElementToInsert(CompilationUnit cu, IJavaElement method) {
        if (method.getParent() instanceof IType) {
            IType itype = (IType)method.getParent();
            TypeDeclaration type = this.searchType((TypeDeclaration)cu.types().get(0), itype.getElementName());
            MethodDeclaration[] methodDeclarationArray = type.getMethods();
            int n = methodDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration m = methodDeclarationArray[n2];
                if (m.getName().toString().equals(method.getElementName())) {
                    return m;
                }
                ++n2;
            }
        }
        return null;
    }
}

