/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTCommentable;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchTools;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTMember;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTMethod;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTMethodBody;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTParameter;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTType;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTMethod
extends SynchJDTCommentable {
    protected IType itype;
    private JDTMethod method;
    private GeneratorPreference preference;

    public SynchJDTMethod(IType itype, GeneratorPreference preference) {
        this.itype = itype;
        this.preference = preference;
    }

    public void visit(JDTJavaElement element) throws JDTVisitorException {
        if (!element.isGenerated()) {
            return;
        }
        this.method = (JDTMethod)element;
        IMethod imethod = null;
        try {
            boolean createMethod = true;
            IMethod[] iMethodArray = this.itype.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (m.getElementName().equals(this.method.getElementName()) && m.getSignature().equals(this.method.getJDTSignature())) {
                    createMethod = false;
                    imethod = m;
                    break;
                }
                ++n2;
            }
            if (createMethod) {
                StringBuffer methodStr = new StringBuffer("\n");
                if (this.itype.isInterface()) {
                    methodStr.append("public ");
                } else {
                    methodStr.append(SynchTools.getVisibility((JDTMember)this.method).toString());
                }
                if (this.method.isConstructor()) {
                    methodStr.append(String.valueOf(this.itype.getElementName()) + "(");
                } else {
                    if (this.method.getReturnType() != null) {
                        String type = this.getTypeAsString(this.method.getReturnType());
                        SynchTools.createImport(this.itype, this.method.getOwner(), this.method.getReturnType().getType());
                        methodStr.append(String.valueOf(type) + " ");
                    } else {
                        methodStr.append("void ");
                    }
                    methodStr.append(String.valueOf(this.method.getElementName()) + "(");
                }
                int nbParam = 0;
                for (JDTParameter p : this.method.getParameters()) {
                    String typeName = p.getElementName();
                    String type = "Undefined";
                    if (p.getType() != null) {
                        type = this.getTypeAsString(p);
                        SynchTools.createImport(this.itype, this.method.getOwner(), p.getType());
                    }
                    if (nbParam > 0) {
                        methodStr.append(", ");
                    }
                    methodStr.append(String.valueOf(type) + " " + typeName);
                    ++nbParam;
                }
                methodStr.append(")");
                if (this.method.getExceptions() != null && this.method.getExceptions().size() > 0) {
                    methodStr.append(" throws ");
                    int nbExc = 0;
                    for (JDTType exception : this.method.getExceptions()) {
                        if (nbExc > 0) {
                            methodStr.append(", ");
                        }
                        methodStr.append(exception.getElementName());
                        if (!SynchTools.isPrimiveType(exception.getQualifiedName()) && exception.getQualifiedName().contains(".")) {
                            this.itype.getCompilationUnit().createImport(exception.getQualifiedName(), null, null);
                        }
                        ++nbExc;
                    }
                }
                if (this.itype.isInterface() || Flags.isAbstract((int)this.method.getFlags())) {
                    methodStr.append(";");
                } else {
                    methodStr.append(" {");
                    if (this.method.getBodies().size() > 0) {
                        for (JDTMethodBody body : this.method.getBodies()) {
                            methodStr.append("\n\t");
                            methodStr.append(body.asText());
                        }
                    } else {
                        methodStr.append(" \n\t// TODO Auto-generated method");
                        if (this.method.getReturnType() != null) {
                            methodStr.append("\n\treturn " + SynchTools.defaultReturn(this.method.getReturnType().getType().getElementName()) + ";");
                        }
                    }
                    methodStr.append("\n }");
                }
                imethod = this.itype.createMethod(methodStr.toString(), null, true, null);
            }
            this.createJavaDocFor(imethod, imethod.getCompilationUnit(), this.method.getComment(), "");
            this.generateExplicitImports(this.method, this.itype);
        }
        catch (JavaModelException e) {
            this.propagateException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.propagateException(e.getMessage(), e);
        }
    }

    private String getTypeAsString(JDTParameter p) throws JavaModelException {
        String type = p.isMultiValued() ? SynchTools.getMultiValued(this.itype, p.getType().getElementName(), this.preference) : p.getType().getElementName();
        return type;
    }

    @Override
    protected BodyDeclaration searchElementToInsert(CompilationUnit cu, IJavaElement method) {
        if (method.getParent() instanceof IType) {
            IType itype = (IType)method.getParent();
            TypeDeclaration type = this.searchType((TypeDeclaration)cu.types().get(0), itype.getElementName());
            MethodDeclaration[] methodDeclarationArray = type.getMethods();
            int n = methodDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration m = methodDeclarationArray[n2];
                if (m.getName().toString().equals(method.getElementName())) {
                    if (m.parameters() != null && m.parameters().size() == 0 && this.method.getParameters().size() == 0) {
                        return m;
                    }
                    if (m.parameters().size() == this.method.getParameters().size()) {
                        int numParam = 0;
                        boolean goodSignature = true;
                        for (Object paramObj : m.parameters()) {
                            if (!(paramObj instanceof SingleVariableDeclaration)) continue;
                            SingleVariableDeclaration param = (SingleVariableDeclaration)paramObj;
                            if (!param.getType().toString().equals(((JDTParameter)this.method.getParameters().get(numParam)).getType().getElementName())) {
                                goodSignature = false;
                            }
                            ++numParam;
                        }
                        if (goodSignature) {
                            return m;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    protected List<String> getJavadocTags() {
        LinkedList<String> lst = new LinkedList<String>();
        if (this.method == null) {
            return lst;
        }
        for (JDTParameter param : this.method.getParameters()) {
            String comment = param.getComment();
            if (comment == null) {
                comment = "";
            }
            lst.add("@param " + param.getElementName() + " " + comment);
        }
        if (this.method.getReturnType() != null) {
            String comment = this.method.getReturnType().getComment();
            if (comment == null) {
                comment = "";
            }
            lst.add("@return " + comment);
        }
        if (this.method.getExceptions() != null) {
            for (JDTType exception : this.method.getExceptions()) {
                lst.add("@throws " + exception.getElementName());
            }
        }
        return lst;
    }

    private void propagateException(String msg, Throwable e) throws JDTVisitorException {
        if (this.preference.stopOnFirstError()) {
            throw new JDTVisitorException(msg, e.getCause());
        }
        System.err.println(msg);
        e.printStackTrace();
    }

    private void generateExplicitImports(JDTMethod srcType, IType destType) throws JDTVisitorException {
        for (Object anImport : srcType.getExplicitRequiredImports()) {
            try {
                destType.getCompilationUnit().createImport(anImport.getQualifiedName(), null, null);
            }
            catch (Exception e) {
                this.propagateException(String.valueOf(destType.getFullyQualifiedName()) + "Can't add explicit import " + anImport.getQualifiedName(), e);
            }
        }
        for (Object anImport : srcType.getExplicitPlainTextRequiredImports()) {
            try {
                destType.getCompilationUnit().createImport((String)anImport, null, null);
            }
            catch (JavaModelException e) {
                this.propagateException(String.valueOf(destType.getFullyQualifiedName()) + "Can't add explicit plain text import " + (String)anImport, e);
            }
        }
    }
}

