/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTCompilationUnit;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchTools;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTCompilationUnit;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTPackageFragment;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitor;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTPackageFragment
extends EObjectImpl
implements JDTVisitor {
    public IPackageFragmentRoot iroot;
    private GeneratorPreference preference;

    public SynchJDTPackageFragment(IPackageFragmentRoot iroot, GeneratorPreference preference) {
        this.iroot = iroot;
        this.preference = preference;
    }

    public void visit(JDTJavaElement element) throws JDTVisitorException {
        if (!element.isGenerated()) {
            return;
        }
        if (!this.preference.isPackageToGenerate(element.getElementName())) {
            return;
        }
        JDTPackageFragment packag = (JDTPackageFragment)element;
        try {
            IJavaElement defaultPackageElement;
            IJavaElement tmp = null;
            IPackageFragment ipack = null;
            tmp = SynchTools.searchIJavaElement((IJavaElement[])this.iroot.getChildren(), (String)packag.getElementName());
            if (tmp != null && tmp instanceof IPackageFragment) {
                ipack = (IPackageFragment)tmp;
            }
            if (packag.getQualifiedName() == null && (defaultPackageElement = SynchTools.searchIJavaElement((IJavaElement[])this.iroot.getChildren(), (String)"")) != null) {
                ipack = (IPackageFragment)defaultPackageElement;
            }
            if (ipack == null) {
                ipack = this.iroot.createPackageFragment(packag.getQualifiedName(), true, null);
            }
            SynchJDTCompilationUnit visitor = new SynchJDTCompilationUnit(ipack, this.preference);
            for (JDTCompilationUnit cu : packag.getCompilationUnits()) {
                cu.accept((JDTVisitor)visitor);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
    }
}

