/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTCommentable;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTField;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTGetterSetter;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTMethod;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchTools;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTField;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTMember;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTMethod;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTType;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitor;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTType
extends SynchJDTCommentable {
    private ICompilationUnit icu;
    private GeneratorPreference preference;
    private IType itype;

    public SynchJDTType(ICompilationUnit icu, GeneratorPreference preference) {
        this.icu = icu;
        this.preference = preference;
    }

    public SynchJDTType(IType itype, GeneratorPreference preference) {
        this.itype = itype;
        this.preference = preference;
    }

    public void visit(JDTJavaElement element) throws JDTVisitorException {
        if (!element.isGenerated()) {
            return;
        }
        if (SynchTools.isPrimiveType(element.getElementName()) && !element.getElementName().equals("String")) {
            return;
        }
        JDTType type = (JDTType)element;
        try {
            IType it = (IType)SynchTools.searchIJavaElement((IJavaElement[])this.getTypes(), (String)type.getElementName());
            if (it == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(SynchTools.getVisibility((JDTMember)type));
                if (type.isClass()) {
                    buffer.append("class ");
                } else if (type.isInterface()) {
                    buffer.append("interface ");
                } else {
                    if (type.isEnum()) {
                        StringBuffer fieldStr = new StringBuffer();
                        int i = 0;
                        for (JDTField field : type.getFields()) {
                            if (i > 0) {
                                fieldStr.append(",\n");
                            }
                            fieldStr.append("\t" + field.getElementName());
                            ++i;
                        }
                        if (!type.getFields().isEmpty()) {
                            fieldStr.append(";\n\n");
                        }
                        it = this.createType("public enum " + type.getElementName() + " { \n" + fieldStr + " \n } ", null, true, null);
                        return;
                    }
                    return;
                }
                buffer.append(type.getElementName());
                if (type.getSuperClass() != null) {
                    buffer.append(" extends ");
                    buffer.append(type.getSuperClass().getElementName());
                }
                if (type.getSuperInterfaces() != null && type.getSuperInterfaces().size() > 0) {
                    if (type.isInterface()) {
                        buffer.append(" extends ");
                    } else {
                        buffer.append(" implements ");
                    }
                    int i = 0;
                    for (Iterator superInterface : type.getSuperInterfaces()) {
                        if (i != 0) {
                            buffer.append(", ");
                        }
                        buffer.append(superInterface.getElementName());
                        ++i;
                    }
                }
                it = this.createType(String.valueOf(buffer.toString()) + " { \n\n}", null, true, null);
            }
            if (type.getSuperClass() != null) {
                SynchTools.createImport(it, type, type.getSuperClass());
            }
            if (type.getSuperInterfaces() != null) {
                for (JDTType superInterface : type.getSuperInterfaces()) {
                    SynchTools.createImport(it, type, superInterface);
                }
            }
            if (type.getComment() != null && !type.getComment().isEmpty()) {
                this.createJavaDocFor(it, it.getCompilationUnit(), type.getComment(), "");
            }
            if (!type.isEnum()) {
                SynchJDTField visitor = new SynchJDTField(it, this.preference);
                for (JDTField field : type.getFields()) {
                    field.accept((JDTVisitor)visitor);
                }
            }
            SynchJDTGetterSetter vgettersetter = new SynchJDTGetterSetter(it, this.preference);
            if (type.isClass()) {
                for (JDTField field : type.getFields()) {
                    field.accept((JDTVisitor)vgettersetter);
                }
            }
            SynchJDTMethod vmethod = new SynchJDTMethod(it, this.preference);
            for (JDTMethod method : type.getMethods()) {
                method.accept((JDTVisitor)vmethod);
            }
            if (!Flags.isAbstract((int)type.getFlags())) {
                JDTType superClass = type.getSuperClass();
                List<JDTType> allSuperInterfaces = this.getAllSuperInterfaces(type);
                if (this.preference.implementMethodsOfAbstractClass()) {
                    this.implementSuperClassAbstractMethods(it, superClass);
                }
                if (this.preference.implementMethodsOfIntefaces()) {
                    for (JDTType superInterface : allSuperInterfaces) {
                        for (JDTMethod superInterfaceMethod : superInterface.getMethods()) {
                            superInterfaceMethod.accept((JDTVisitor)vmethod);
                        }
                    }
                }
            }
            SynchJDTType vClass = new SynchJDTType(it, this.preference);
            for (JDTType child : type.getTypes()) {
                child.accept((JDTVisitor)vClass);
            }
            this.generateExplicitImports(type, it);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
    }

    private void generateExplicitImports(JDTType containerType, IType it) throws JDTVisitorException {
        for (Object anImport : containerType.getExplicitRequiredImports()) {
            try {
                it.getCompilationUnit().createImport(anImport.getQualifiedName(), null, null);
            }
            catch (Exception e) {
                this.propagateException(String.valueOf(it.getFullyQualifiedName()) + "Can't add explicit import " + anImport.getQualifiedName(), e);
            }
        }
        for (Object anImport : containerType.getExplicitPlainTextRequiredImports()) {
            try {
                it.getCompilationUnit().createImport((String)anImport, null, null);
            }
            catch (JavaModelException e) {
                this.propagateException(String.valueOf(it.getFullyQualifiedName()) + "Can't add explicit plain text import " + (String)anImport, e);
            }
        }
    }

    private IType[] getTypes() throws JavaModelException {
        if (this.icu != null) {
            return this.icu.getTypes();
        }
        return this.itype.getTypes();
    }

    private IType createType(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (this.icu != null) {
            return this.icu.createType(contents, sibling, force, monitor);
        }
        return this.itype.createType(contents, sibling, force, monitor);
    }

    protected TypeDeclaration searchElementToInsert(CompilationUnit cu, IJavaElement typeName) {
        if (!(cu.types().get(0) instanceof TypeDeclaration)) {
            return null;
        }
        TypeDeclaration classType = (TypeDeclaration)cu.types().get(0);
        return this.searchType(classType, typeName.getElementName());
    }

    @Override
    protected List<String> getJavadocTags() {
        LinkedList<String> lst = new LinkedList<String>();
        lst.add("@author");
        return lst;
    }

    public List<JDTType> getAllSuperInterfaces(JDTType _type) {
        LinkedList<JDTType> superInterfaces = new LinkedList<JDTType>();
        superInterfaces.addAll((Collection<JDTType>)_type.getSuperInterfaces());
        if (_type.getSuperClass() != null && _type.getSuperClass().isAbstract()) {
            superInterfaces.addAll(this.getAllSuperInterfaces(_type.getSuperClass()));
        }
        for (JDTType superInterface : _type.getSuperInterfaces()) {
            superInterfaces.addAll(this.getAllSuperInterfaces(superInterface));
        }
        return superInterfaces;
    }

    public void implementSuperClassAbstractMethods(IType it, JDTType superClass) throws JDTVisitorException {
        if (superClass == null) {
            return;
        }
        SynchJDTMethod vmethod = new SynchJDTMethod(it, this.preference);
        if (Flags.isAbstract((int)superClass.getFlags())) {
            for (JDTMethod superClassAbstractMethod : superClass.getMethods()) {
                if (!superClassAbstractMethod.isAbstract()) continue;
                superClassAbstractMethod.setAbstract(false);
                superClassAbstractMethod.accept((JDTVisitor)vmethod);
                superClassAbstractMethod.setAbstract(true);
            }
            JDTType superClassSuperClass = superClass.getSuperClass();
            if (superClassSuperClass != null) {
                this.implementSuperClassAbstractMethods(it, superClassSuperClass);
            }
        }
    }

    private void propagateException(String msg, Throwable e) throws JDTVisitorException {
        if (this.preference.stopOnFirstError()) {
            throw new JDTVisitorException(msg, e.getCause());
        }
        System.err.println(msg);
        e.printStackTrace();
    }
}

