/*****************************************************************************
 * Copyright (c) 2011 Nicolas Deblock & Cedric Dumoulin & Manuel Giles.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	Nicolas Deblock  nico.deblock@gmail.com  - Meta-model conception
 * 	Cedric Dumoulin  Cedric.dumoulin@lifl.fr - Meta-model conception
 * 	Manuel Giles	 giles.manu@live.fr		 - Meta-model conception
 *
 *****************************************************************************/

/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTCompilationUnit;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTPackageFragment;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTParent;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTType;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JdtmmPackage;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.eclipse.uml2.common.util.SubsetSupersetEObjectContainmentWithInverseEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>JDT Compilation Unit</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.impl.JDTCompilationUnitImpl#getChildren <em>Children</em>}</li>
 * <li>{@link org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.impl.JDTCompilationUnitImpl#getPackageFragment <em>Package Fragment</em>}</li>
 * <li>{@link org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.impl.JDTCompilationUnitImpl#getTypes <em>Types</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class JDTCompilationUnitImpl extends JDTTypeRootImpl implements JDTCompilationUnit {

	/**
	 * The cached value of the '{@link #getTypes() <em>Types</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<JDTType> types;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected JDTCompilationUnitImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return JdtmmPackage.Literals.JDT_COMPILATION_UNIT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EList<JDTJavaElement> getChildren() {
		return new DerivedUnionEObjectEList<JDTJavaElement>(JDTJavaElement.class, this, JdtmmPackage.JDT_COMPILATION_UNIT__CHILDREN, CHILDREN_ESUBSETS);
	}

	/**
	 * The array of subset feature identifiers for the '{@link #getChildren() <em>Children</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected static final int[] CHILDREN_ESUBSETS = new int[] { JdtmmPackage.JDT_COMPILATION_UNIT__TYPES };

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public JDTPackageFragment getPackageFragment() {
		if (eContainerFeatureID() != JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT) {
			return null;
		}
		return (JDTPackageFragment) eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public NotificationChain basicSetPackageFragment(JDTPackageFragment newPackageFragment, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newPackageFragment, JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setPackageFragment(JDTPackageFragment newPackageFragment) {
		if (newPackageFragment != eInternalContainer() || (eContainerFeatureID() != JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT && newPackageFragment != null)) {
			if (EcoreUtil.isAncestor(this, newPackageFragment)) {
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			}
			NotificationChain msgs = null;
			if (eInternalContainer() != null) {
				msgs = eBasicRemoveFromContainer(msgs);
			}
			if (newPackageFragment != null) {
				msgs = ((InternalEObject) newPackageFragment).eInverseAdd(this, JdtmmPackage.JDT_PACKAGE_FRAGMENT__COMPILATION_UNITS, JDTPackageFragment.class, msgs);
			}
			msgs = basicSetPackageFragment(newPackageFragment, msgs);
			if (msgs != null) {
				msgs.dispatch();
			}
		}
		else if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT, newPackageFragment, newPackageFragment));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public boolean isSetPackageFragment() {
		return getPackageFragment() != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EList<JDTType> getTypes() {
		if (types == null) {
			types = new SubsetSupersetEObjectContainmentWithInverseEList<JDTType>(JDTType.class, this, JdtmmPackage.JDT_COMPILATION_UNIT__TYPES, TYPES_ESUPERSETS, null, JdtmmPackage.JDT_TYPE__COMPILATION_UNIT);
		}
		return types;
	}

	/**
	 * The array of superset feature identifiers for the '{@link #getTypes() <em>Types</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getTypes()
	 * @generated
	 * @ordered
	 */
	protected static final int[] TYPES_ESUPERSETS = new int[] { JdtmmPackage.JDT_COMPILATION_UNIT__CHILDREN };

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT:
			if (eInternalContainer() != null) {
				msgs = eBasicRemoveFromContainer(msgs);
			}
			return basicSetPackageFragment((JDTPackageFragment) otherEnd, msgs);
		case JdtmmPackage.JDT_COMPILATION_UNIT__TYPES:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getTypes()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT:
			return basicSetPackageFragment(null, msgs);
		case JdtmmPackage.JDT_COMPILATION_UNIT__TYPES:
			return ((InternalEList<?>) getTypes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT:
			return eInternalContainer().eInverseRemove(this, JdtmmPackage.JDT_PACKAGE_FRAGMENT__COMPILATION_UNITS, JDTPackageFragment.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT:
			return getPackageFragment();
		case JdtmmPackage.JDT_COMPILATION_UNIT__TYPES:
			return getTypes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT:
			setPackageFragment((JDTPackageFragment) newValue);
			return;
		case JdtmmPackage.JDT_COMPILATION_UNIT__TYPES:
			getTypes().clear();
			getTypes().addAll((Collection<? extends JDTType>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT:
			setPackageFragment((JDTPackageFragment) null);
			return;
		case JdtmmPackage.JDT_COMPILATION_UNIT__TYPES:
			getTypes().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case JdtmmPackage.JDT_COMPILATION_UNIT__PACKAGE_FRAGMENT:
			return isSetPackageFragment();
		case JdtmmPackage.JDT_COMPILATION_UNIT__TYPES:
			return types != null && !types.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean isSetChildren() {
		return super.isSetChildren()
				|| eIsSet(JdtmmPackage.JDT_COMPILATION_UNIT__TYPES);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public JDTParent getParent() {
		return getPackageFragment();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public JDTParent basicGetParent() {
		return getPackageFragment();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public boolean isSetParent() {
		return false;
	}

} // JDTCompilationUnitImpl
