/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VisibilityKind implements Enumerator
{
    PUBLIC(0, "public", "public"),
    PROTECTED(1, "protected", "protected"),
    PRIVATE(2, "private", "private");

    public static final int PUBLIC_VALUE = 0;
    public static final int PROTECTED_VALUE = 1;
    public static final int PRIVATE_VALUE = 2;
    private static final VisibilityKind[] VALUES_ARRAY;
    public static final List<VisibilityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VisibilityKind[]{PUBLIC, PROTECTED, PRIVATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VisibilityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityKind get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 1: {
                return PROTECTED;
            }
            case 2: {
                return PRIVATE;
            }
        }
        return null;
    }

    private VisibilityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

