/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.metamodel.jdt.utils;

import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;

public abstract class DerivedNotifyingEList<E, T>
extends AbstractSequentialList<E>
implements EList<E>,
NotifyingList<E> {
    protected NotifyingList<T> backupList;
    private Object notifier;
    private Object feature;
    private int featureID;
    private Adapter backupListChangeListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() != DerivedNotifyingEList.this.backupList.getNotifier() || msg.getFeature() != DerivedNotifyingEList.this.backupList.getFeature()) {
                return;
            }
            NotificationImpl newNotification = DerivedNotifyingEList.this.createNotification(msg);
            newNotification.dispatch();
        }
    };

    public DerivedNotifyingEList(NotifyingList<T> backupList) {
        this(backupList, backupList.getNotifier(), null, 0);
    }

    public DerivedNotifyingEList(NotifyingList<T> backupList, Object feature, int featureID) {
        this(backupList, backupList.getNotifier(), feature, featureID);
    }

    public DerivedNotifyingEList(NotifyingList<T> backupList, Object notifier, Object feature, int featureID) {
        if (feature == backupList.getFeature() || featureID == backupList.getFeatureID()) {
            throw new IllegalArgumentException("Feature and featureID should be different from the backupList.feature and backupList.featureID. [" + feature + "==" + backupList.getFeature() + " - " + featureID + "==" + backupList.getFeatureID() + "]");
        }
        this.backupList = backupList;
        this.notifier = notifier;
        this.feature = feature;
        this.featureID = featureID;
        this.attachListener();
    }

    protected void attachListener() {
        ((Notifier)this.notifier).eAdapters().add((Object)this.backupListChangeListener);
    }

    public Object getNotifier() {
        return this.notifier;
    }

    public Object getFeature() {
        return this.feature;
    }

    public int getFeatureID() {
        return this.featureID;
    }

    protected NotificationImpl createNotification(Notification origNotification) {
        return new NotificationImpl(origNotification.getEventType(), origNotification.getOldValue(), origNotification.getNewValue(), origNotification.getPosition(), origNotification.wasSet()){

            public Object getNotifier() {
                return DerivedNotifyingEList.this.getNotifier();
            }

            public Object getFeature() {
                return DerivedNotifyingEList.this.getFeature();
            }

            public int getFeatureID(Class<?> expectedClass) {
                return DerivedNotifyingEList.this.getFeatureID();
            }
        };
    }

    public NotifyingList<T> getBackupList() {
        return this.backupList;
    }

    protected abstract E doGet(int var1);

    public void move(int newPosition, E object) {
        this.move(newPosition, this.indexOf(object));
    }

    public E move(int newPosition, int oldPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.backupList.size();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new DerivedListIterator(index);
    }

    public class DerivedListIterator
    implements ListIterator<E> {
        protected int cursor = 0;
        protected int lastCursor = -1;
        protected int expectedModCount;

        public DerivedListIterator(int index) {
            this.expectedModCount = DerivedNotifyingEList.this.modCount;
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != DerivedNotifyingEList.this.size();
        }

        @Override
        public E next() {
            try {
                Object next = DerivedNotifyingEList.this.doGet(this.cursor);
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                Object previous = DerivedNotifyingEList.this.doGet(--this.cursor);
                this.lastCursor = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

