/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.papyrus.java.profile.java.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.java.profile.java.JavaMethod;
import org.eclipse.papyrus.java.profile.java.JavaPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.papyrus.java.profile.java.JavaMethod} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 *
 * @generated
 */
public class JavaMethodItemProvider
		extends JavaNamedElementItemProvider
		implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public JavaMethodItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addIsStaticPropertyDescriptor(object);
			addIsFinalPropertyDescriptor(object);
			addIsAbstractPropertyDescriptor(object);
			addIsNativePropertyDescriptor(object);
			addIsSynchronizedPropertyDescriptor(object);
			addIsConstructorPropertyDescriptor(object);
			addBase_OperationPropertyDescriptor(object);
			addExplicitPlainTextRequiredImportsPropertyDescriptor(object);
			addExplicitRequiredImportsPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Is Static feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addIsStaticPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_isStatic_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_isStatic_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__IS_STATIC,
						true,
						false,
						false,
						ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Is Final feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addIsFinalPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_isFinal_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_isFinal_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__IS_FINAL,
						true,
						false,
						false,
						ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Is Abstract feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addIsAbstractPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_isAbstract_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_isAbstract_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__IS_ABSTRACT,
						true,
						false,
						false,
						ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Is Native feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addIsNativePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_isNative_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_isNative_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__IS_NATIVE,
						true,
						false,
						false,
						ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Is Synchronized feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addIsSynchronizedPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_isSynchronized_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_isSynchronized_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__IS_SYNCHRONIZED,
						true,
						false,
						false,
						ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Is Constructor feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addIsConstructorPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_isConstructor_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_isConstructor_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__IS_CONSTRUCTOR,
						true,
						false,
						false,
						ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Base Operation feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addBase_OperationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_base_Operation_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_base_Operation_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__BASE_OPERATION,
						true,
						false,
						true,
						null,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Explicit Plain Text Required Imports feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addExplicitPlainTextRequiredImportsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_explicitPlainTextRequiredImports_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_explicitPlainTextRequiredImports_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__EXPLICIT_PLAIN_TEXT_REQUIRED_IMPORTS,
						true,
						false,
						false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
						null,
						null));
	}

	/**
	 * This adds a property descriptor for the Explicit Required Imports feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addExplicitRequiredImportsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
				(createItemPropertyDescriptor
				(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_JavaMethod_explicitRequiredImports_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_JavaMethod_explicitRequiredImports_feature", "_UI_JavaMethod_type"),
						JavaPackage.Literals.JAVA_METHOD__EXPLICIT_REQUIRED_IMPORTS,
						true,
						false,
						true,
						null,
						null,
						null));
	}

	/**
	 * This returns JavaMethod.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/JavaMethod"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((JavaMethod) object).getName();
		return label == null || label.length() == 0 ?
				getString("_UI_JavaMethod_type") :
				getString("_UI_JavaMethod_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(JavaMethod.class)) {
		case JavaPackage.JAVA_METHOD__IS_STATIC:
		case JavaPackage.JAVA_METHOD__IS_FINAL:
		case JavaPackage.JAVA_METHOD__IS_ABSTRACT:
		case JavaPackage.JAVA_METHOD__IS_NATIVE:
		case JavaPackage.JAVA_METHOD__IS_SYNCHRONIZED:
		case JavaPackage.JAVA_METHOD__IS_CONSTRUCTOR:
		case JavaPackage.JAVA_METHOD__EXPLICIT_PLAIN_TEXT_REQUIRED_IMPORTS:
			fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

}
