/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.papyrus.java.profile.java.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.java.profile.java.JavaClass;
import org.eclipse.papyrus.java.profile.java.JavaGen;
import org.eclipse.papyrus.java.profile.java.JavaMethod;
import org.eclipse.papyrus.java.profile.java.JavaNamedElement;
import org.eclipse.papyrus.java.profile.java.JavaPackage;
import org.eclipse.papyrus.java.profile.java.JavaPackage_;
import org.eclipse.papyrus.java.profile.java.JavaParameter;
import org.eclipse.papyrus.java.profile.java.JavaProject;
import org.eclipse.papyrus.java.profile.java.JavaProperty;
import org.eclipse.papyrus.java.profile.java.JavaSrcFolder;
import org.eclipse.papyrus.java.profile.java.PrimitiveType;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)} to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 *
 * @see org.eclipse.papyrus.java.profile.java.JavaPackage
 * @generated
 */
public class JavaSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected static JavaPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public JavaSwitch() {
		if (modelPackage == null) {
			modelPackage = JavaPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case JavaPackage.JAVA_CLASS: {
			JavaClass javaClass = (JavaClass) theEObject;
			T result = caseJavaClass(javaClass);
			if (result == null) {
				result = caseJavaGen(javaClass);
			}
			if (result == null) {
				result = caseJavaNamedElement(javaClass);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_GEN: {
			JavaGen javaGen = (JavaGen) theEObject;
			T result = caseJavaGen(javaGen);
			if (result == null) {
				result = caseJavaNamedElement(javaGen);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_NAMED_ELEMENT: {
			JavaNamedElement javaNamedElement = (JavaNamedElement) theEObject;
			T result = caseJavaNamedElement(javaNamedElement);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_PACKAGE_: {
			JavaPackage_ javaPackage_ = (JavaPackage_) theEObject;
			T result = caseJavaPackage_(javaPackage_);
			if (result == null) {
				result = caseJavaGen(javaPackage_);
			}
			if (result == null) {
				result = caseJavaNamedElement(javaPackage_);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_METHOD: {
			JavaMethod javaMethod = (JavaMethod) theEObject;
			T result = caseJavaMethod(javaMethod);
			if (result == null) {
				result = caseJavaNamedElement(javaMethod);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_PARAMETER: {
			JavaParameter javaParameter = (JavaParameter) theEObject;
			T result = caseJavaParameter(javaParameter);
			if (result == null) {
				result = caseJavaNamedElement(javaParameter);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_PROPERTY: {
			JavaProperty javaProperty = (JavaProperty) theEObject;
			T result = caseJavaProperty(javaProperty);
			if (result == null) {
				result = caseJavaNamedElement(javaProperty);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.PRIMITIVE_TYPE: {
			PrimitiveType primitiveType = (PrimitiveType) theEObject;
			T result = casePrimitiveType(primitiveType);
			if (result == null) {
				result = caseJavaGen(primitiveType);
			}
			if (result == null) {
				result = caseJavaNamedElement(primitiveType);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_PROJECT: {
			JavaProject javaProject = (JavaProject) theEObject;
			T result = caseJavaProject(javaProject);
			if (result == null) {
				result = caseJavaGen(javaProject);
			}
			if (result == null) {
				result = caseJavaNamedElement(javaProject);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case JavaPackage.JAVA_SRC_FOLDER: {
			JavaSrcFolder javaSrcFolder = (JavaSrcFolder) theEObject;
			T result = caseJavaSrcFolder(javaSrcFolder);
			if (result == null) {
				result = caseJavaGen(javaSrcFolder);
			}
			if (result == null) {
				result = caseJavaNamedElement(javaSrcFolder);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaClass(JavaClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gen</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gen</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaGen(JavaGen object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaNamedElement(JavaNamedElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Package </em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Package </em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaPackage_(JavaPackage_ object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Method</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Method</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaMethod(JavaMethod object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaParameter(JavaParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaProperty(JavaProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Primitive Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Primitive Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePrimitiveType(PrimitiveType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Project</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Project</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaProject(JavaProject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Src Folder</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Src Folder</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJavaSrcFolder(JavaSrcFolder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} // JavaSwitch
