/*
 * Copyright (C) 2007 Jlio Vilmar Gesser.
 *
 * This file is part of Java 1.5 parser and Abstract Syntax Tree.
 *
 * Java 1.5 parser and Abstract Syntax Tree is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Java 1.5 parser and Abstract Syntax Tree is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Java 1.5 parser and Abstract Syntax Tree.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on 23/05/2008
 */
package japa.parser.ast;

import japa.parser.ast.body.JavadocComment;

/**
 * Abstract class for all AST nodes that represent comments.
 *
 * @see BlockComment
 * @see LineComment
 * @see JavadocComment
 * @author Julio Vilmar Gesser
 */
public abstract class Comment extends Node {

	private String content;

	public Comment() {
	}

	public Comment(int beginLine, int beginColumn, int endLine, int endColumn, String content) {
		super(beginLine, beginColumn, endLine, endColumn);
		this.content = content;
	}

	/**
	 * Return the text of the comment.
	 *
	 * @return text of the comment
	 */
	public final String getContent() {
		return content;
	}

	/**
	 * Sets the text of the comment.
	 *
	 * @param content
	 *            the text of the comment to set
	 */
	public void setContent(String content) {
		this.content = content;
	}
}
