/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.reverse.ui;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.java.reverse.ui.JavaCodeReverse;
import org.eclipse.papyrus.java.reverse.ui.Messages;
import org.eclipse.papyrus.java.reverse.ui.dialog.ReverseCodeDialog;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Package;

public class ReverseCodeHandler
extends AbstractHandler
implements IHandler {
    private static String DefaultGenerationModeleName = "generated";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain;
        Resource umlResource;
        try {
            umlResource = this.getUmlResource();
        }
        catch (NullPointerException e) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            Status errorStatus = new Status(4, "org.eclipse.papyrus.java.reverse.ui", Messages.ReverseCodeHandler_NoModelError_Title);
            ErrorDialog.openError((Shell)shell, (String)"", (String)Messages.ReverseCodeHandler_NoModelError_Message, (IStatus)errorStatus);
            return null;
        }
        String modelUid = this.getModelUid(umlResource);
        System.out.println("Model uid :" + modelUid);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getShell();
        final ReverseCodeDialog dialog = this.getDialog(shell, modelUid);
        int res = dialog.open();
        if (res == 1) {
            System.out.println("Canceled by user.");
            return null;
        }
        try {
            editingDomain = this.getEditingDomain();
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new ExecutionException(e.getMessage());
        }
        RecordingCommand command = new RecordingCommand(editingDomain, "Reverse Java Code"){

            protected void doExecute() {
                ReverseCodeHandler.this.doExecute(dialog);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
        return null;
    }

    private String getModelUid(Resource umlResource) {
        String modelUid = umlResource.getURI().toPlatformString(true);
        if (modelUid == null) {
            System.err.println("Can't compute relatif model uid. Use absolute one");
            modelUid = umlResource.getURI().path();
        }
        return modelUid;
    }

    protected void doExecute(ReverseCodeDialog dialog) {
        List<String> searchPaths = Arrays.asList(dialog.getSearchPath());
        Resource umlResource = this.getUmlResource();
        String packageName = this.getPackageName(dialog);
        JavaCodeReverse reverse = new JavaCodeReverse(this.getRootPackage(umlResource), packageName, searchPaths);
        reverse.executeCodeReverse(umlResource, packageName, searchPaths);
    }

    protected ReverseCodeDialog getDialog(Shell shell, String modelUid) {
        return new ReverseCodeDialog(shell, modelUid, null, null);
    }

    protected String getPackageName(ReverseCodeDialog dialog) {
        String generationPackageName = dialog.getValue();
        if (generationPackageName == null || generationPackageName.length() == 0) {
            generationPackageName = DefaultGenerationModeleName;
        }
        return generationPackageName;
    }

    protected Resource getUmlResource() {
        Resource umlResource = UmlUtils.getUmlModel().getResource();
        return umlResource;
    }

    protected Package getRootPackage(Resource umlResource) {
        Package rootPackage = (Package)umlResource.getContents().get(0);
        return rootPackage;
    }

    protected IMultiDiagramEditor getMultiDiagramEditor() {
        return EditorUtils.getMultiDiagramEditor();
    }

    protected TransactionalEditingDomain getEditingDomain() throws ServiceException {
        return ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain();
    }
}

