/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.reverse.ui;

import java.util.LinkedList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.TreeSelection;

public class TreeSelectionList
extends LinkedList<IJavaElement> {
    private static final long serialVersionUID = -5749380826507346600L;
    private boolean includePackages;
    private boolean includeCU;

    public TreeSelectionList(TreeSelection treeSelection, boolean includePackages, boolean includeCU) throws JavaModelException {
        this.includePackages = includePackages;
        this.includeCU = includeCU;
        this.addAll(treeSelection);
    }

    private void addAll(TreeSelection selection) throws JavaModelException {
        for (IJavaElement item : selection) {
            this.scanJavaElement(item);
        }
    }

    private void scanCU(ICompilationUnit item) {
        if (this.includeCU) {
            this.add(item);
        }
    }

    private void scanPackage(IPackageFragment item) throws JavaModelException {
        if (this.includePackages) {
            this.add(item);
        }
        IJavaElement[] iJavaElementArray = item.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            this.scanJavaElement(child);
            ++n2;
        }
    }

    private void scanFolder(IPackageFragmentRoot item) throws JavaModelException {
        IJavaElement[] iJavaElementArray = item.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            this.scanJavaElement(child);
            ++n2;
        }
    }

    private void scanJavaElement(IJavaElement item) throws JavaModelException {
        switch (item.getElementType()) {
            case 3: {
                this.scanFolder((IPackageFragmentRoot)item);
                break;
            }
            case 4: {
                this.scanPackage((IPackageFragment)item);
                break;
            }
            case 5: {
                this.scanCU((ICompilationUnit)item);
            }
        }
    }
}

