/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.expr;

import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.type.Type;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.VoidVisitor;
import java.util.List;

public final class ArrayCreationExpr
extends Expression {
    private Type type;
    private int arrayCount;
    private ArrayInitializerExpr initializer;
    private List<Expression> dimensions;

    public ArrayCreationExpr() {
    }

    public ArrayCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type, int arrayCount, ArrayInitializerExpr initializer) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.type = type;
        this.arrayCount = arrayCount;
        this.initializer = initializer;
        this.dimensions = null;
    }

    public ArrayCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type, List<Expression> dimensions, int arrayCount) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.type = type;
        this.arrayCount = arrayCount;
        this.dimensions = dimensions;
        this.initializer = null;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public List<Expression> getDimensions() {
        return this.dimensions;
    }

    public ArrayInitializerExpr getInitializer() {
        return this.initializer;
    }

    public Type getType() {
        return this.type;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setDimensions(List<Expression> dimensions) {
        this.dimensions = dimensions;
    }

    public void setInitializer(ArrayInitializerExpr initializer) {
        this.initializer = initializer;
    }

    public void setType(Type type) {
        this.type = type;
    }
}

